/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;

public abstract class GraphPathRecord {
    protected final GraphPathRecord parent;
    private final int depth;
    private final Object obj;
    private long size;
    private final long address;
    private String toString;

    GraphPathRecord(GraphPathRecord parent, int depth, Object obj) {
        this.parent = parent;
        this.obj = obj;
        this.depth = depth;
        this.address = VM.current().addressOf(obj);
    }

    Object obj() {
        return this.obj;
    }

    public abstract String path();

    public Class<?> klass() {
        return this.obj.getClass();
    }

    public long size() {
        if (this.size == 0L) {
            this.size = VM.current().sizeOf(this.obj);
        }
        return this.size;
    }

    void setSize(long size) {
        this.size = size;
    }

    public long address() {
        return this.address;
    }

    public String objToString() {
        String v = this.toString;
        if (v == null) {
            this.toString = v = ObjectUtils.safeToString(this.obj);
        }
        return v;
    }

    public int depth() {
        return this.depth;
    }
}

