/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.reflect.Field;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.ContendedSupport;

public class FieldData {
    private final String name;
    private final String type;
    private final String klass;
    private final Field refField;
    private final boolean isContended;
    private final String contendedGroup;

    public static FieldData create(String hostKlass, String fieldName, String fieldType) {
        return new FieldData(null, hostKlass, fieldName, fieldType, false, null);
    }

    public static FieldData parse(Field field) {
        return new FieldData(field, ClassUtils.getSafeName(field.getDeclaringClass()), field.getName(), ClassUtils.getSafeName(field.getType()), ContendedSupport.isContended(field), ContendedSupport.contendedGroup(field));
    }

    private FieldData(Field refField, String hostKlass, String fieldName, String fieldType, boolean isContended, String contendedGroup) {
        this.klass = hostKlass;
        this.name = fieldName;
        this.type = fieldType;
        this.refField = refField;
        this.isContended = isContended;
        this.contendedGroup = contendedGroup;
    }

    public String typeClass() {
        return this.type;
    }

    public String hostClass() {
        return this.klass;
    }

    public String name() {
        return this.name;
    }

    public boolean isContended() {
        return this.isContended;
    }

    public String contendedGroup() {
        return this.contendedGroup;
    }

    public Field refField() {
        return this.refField;
    }

    public String toString() {
        return this.name + ": " + this.type;
    }
}

