/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.quickautobalance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.postgresql.Driver;
import org.postgresql.PGProperty;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.jdbc.StatementCancelState;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.quickautobalance.ConnectionInfo;
import org.postgresql.quickautobalance.DataNode;
import org.postgresql.quickautobalance.LoadBalanceHeartBeating;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Cluster {
    private static Log LOGGER = Logger.getLogger(Cluster.class.getName());
    private static final double CLOSE_CONNECTION_PERCENTAGE_EACH_TIME = 0.2;
    private static final int MIN_RESERVED_CON_UNSET_PARAMS = -1;
    private final String urlIdentifier;
    private final Set<HostSpec> dns;
    private final Queue<ConnectionInfo> abandonedConnectionList;
    private final Map<HostSpec, DataNode> cachedDnList;
    private final List<Properties> cachedPropertiesList;
    private volatile int minReservedConPerCluster;
    private volatile boolean enableMinReservedConPerCluster;
    private volatile int minReservedConPerDatanode;
    private volatile boolean enableMinReservedConPerDatanode;
    private volatile long quickAutoBalanceStartTime;
    private int totalAbandonedConnectionSize;

    public Cluster(String urlIdentifier, Properties properties) throws PSQLException {
        this.urlIdentifier = urlIdentifier;
        HostSpec[] hostSpecs = Driver.getURLHostSpecs(properties);
        this.dns = new HashSet<HostSpec>();
        this.dns.addAll(Arrays.asList(hostSpecs));
        this.cachedDnList = new ConcurrentHashMap<HostSpec, DataNode>();
        for (HostSpec hostSpec : hostSpecs) {
            DataNode dataNode = new DataNode(hostSpec);
            this.cachedDnList.put(hostSpec, dataNode);
        }
        this.updateParams(properties);
        this.abandonedConnectionList = new ConcurrentLinkedQueue<ConnectionInfo>();
        this.cachedPropertiesList = new Vector<Properties>();
        this.cachedPropertiesList.add(properties);
        this.quickAutoBalanceStartTime = 0L;
        this.totalAbandonedConnectionSize = 0;
    }

    public void setConnectionState(PgConnection pgConnection, StatementCancelState state) {
        String socketAddress = pgConnection.getSocketAddress();
        HostSpec hostSpec = this.calculateHostSpec(socketAddress);
        if (hostSpec != null && !this.dns.contains(hostSpec)) {
            return;
        }
        DataNode dataNode = this.cachedDnList.get(hostSpec);
        if (dataNode != null) {
            dataNode.setConnectionState(pgConnection, state);
        }
    }

    private HostSpec calculateHostSpec(String socketAddress) {
        String urlClient = socketAddress.split("/")[1];
        String[] urlClientSplit = urlClient.split(":");
        if (urlClientSplit.length == 2) {
            String host = urlClientSplit[0];
            int port = Integer.parseInt(urlClientSplit[1]);
            return new HostSpec(host, port);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(PgConnection pgConnection, Properties properties) throws PSQLException {
        if (pgConnection == null || properties == null) {
            return;
        }
        String socketAddress = pgConnection.getSocketAddress();
        HostSpec hostSpec = this.calculateHostSpec(socketAddress);
        if (hostSpec != null && !this.dns.contains(hostSpec)) {
            return;
        }
        this.setProperties(properties);
        Map<HostSpec, DataNode> map = this.cachedDnList;
        synchronized (map) {
            this.cachedDnList.get(hostSpec).setConnection(pgConnection, properties, hostSpec);
            this.decrementCachedCreatingConnectionSize(hostSpec);
            this.updateParams(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Properties properties) {
        List<Properties> list = this.cachedPropertiesList;
        synchronized (list) {
            for (int i = 0; i < this.cachedPropertiesList.size(); ++i) {
                Properties prop = this.cachedPropertiesList.get(i);
                if (!prop.getProperty("user", "").equals(properties.getProperty("user", null))) continue;
                this.cachedPropertiesList.set(i, properties);
                return;
            }
            this.cachedPropertiesList.add(properties);
        }
    }

    public int decrementCachedCreatingConnectionSize(HostSpec hostSpec) {
        if (!this.cachedDnList.containsKey(hostSpec)) {
            LOGGER.error(GT.tr("Can not find hostSpec: {0} in Cluster: {1}.", hostSpec.toString(), this.urlIdentifier));
            return 0;
        }
        DataNode dataNode = this.cachedDnList.get(hostSpec);
        if (dataNode != null) {
            return dataNode.decrementCachedCreatingConnectionSize();
        }
        LOGGER.error(GT.tr("Can not find hostSpec: {0} in Cluster: {1}.", hostSpec.toString(), this.urlIdentifier));
        return 0;
    }

    private void updateMinReservedConPerCluster(Properties properties) throws PSQLException {
        int perCluster = Cluster.parseMinReservedConPerCluster(properties);
        if (perCluster == -1) {
            return;
        }
        if (this.enableMinReservedConPerCluster) {
            this.minReservedConPerCluster = Math.min(this.minReservedConPerCluster, perCluster);
        } else {
            this.enableMinReservedConPerCluster = true;
            this.minReservedConPerCluster = perCluster;
        }
    }

    private void updateMinReservedConPerDatanode(Properties properties) throws PSQLException {
        int perDatanode = Cluster.parseMinReservedConPerDatanode(properties);
        if (perDatanode == -1) {
            return;
        }
        if (this.enableMinReservedConPerDatanode) {
            this.minReservedConPerDatanode = Math.min(this.minReservedConPerDatanode, perDatanode);
        } else {
            this.enableMinReservedConPerDatanode = true;
            this.minReservedConPerDatanode = perDatanode;
        }
    }

    public static int parseMinReservedConPerCluster(Properties properties) throws PSQLException {
        int perCluster;
        String param = PGProperty.MIN_RESERVED_CON_PER_CLUSTER.get(properties);
        if (param == null) {
            return -1;
        }
        try {
            perCluster = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Parameter minReservedConPerCluster={0} parsed failed, value range: int && [0, 100].", PGProperty.MIN_RESERVED_CON_PER_CLUSTER.get(properties)), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (perCluster < 0 || perCluster > 100) {
            throw new PSQLException(GT.tr("Parameter minReservedConPerCluster={0} parsed failed, value range: int && [0, 100].", String.valueOf(perCluster)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return perCluster;
    }

    public static int parseMinReservedConPerDatanode(Properties properties) throws PSQLException {
        int perDatanode;
        String param = PGProperty.MIN_RESERVED_CON_PER_DATANODE.get(properties);
        if (param == null) {
            return -1;
        }
        try {
            perDatanode = Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Parameter minReservedConPerDatanode={0} parsed failed, value range: int && [0, 100].", PGProperty.MIN_RESERVED_CON_PER_DATANODE.get(properties)), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (perDatanode < 0 || perDatanode > 100) {
            throw new PSQLException(GT.tr("Parameter minReservedConPerDatanode={0} parsed failed, value range: int && [0, 100].", String.valueOf(perDatanode)), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return perDatanode;
    }

    private void updateParams(Properties properties) throws PSQLException {
        this.updateMinReservedConPerCluster(properties);
        this.updateMinReservedConPerDatanode(properties);
    }

    public ConnectionInfo getConnectionInfo(PgConnection connection) {
        String socketAddress = connection.getSocketAddress();
        HostSpec hostSpec = this.calculateHostSpec(socketAddress);
        DataNode dataNode = this.cachedDnList.get(hostSpec);
        return hostSpec != null && dataNode != null ? dataNode.getConnectionInfo(connection) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HostSpec> sortDnsByLeastConn(List<HostSpec> hostSpecs) {
        Map dataNodeCompareInfoMap;
        Map<HostSpec, DataNode> map = this.cachedDnList;
        synchronized (map) {
            dataNodeCompareInfoMap = hostSpecs.stream().collect(Collectors.toMap(Function.identity(), hostSpec -> {
                DataNode dataNode = this.cachedDnList.get(hostSpec);
                int cachedConnectionListSize = dataNode.getCachedConnectionListSize();
                int cachedCreatingConnectionSize = dataNode.getCachedCreatingConnectionSize();
                boolean dataNodeState = dataNode.getDataNodeState();
                return new DataNodeCompareInfo(cachedConnectionListSize, cachedCreatingConnectionSize, dataNodeState);
            }));
        }
        hostSpecs.sort((o1, o2) -> {
            boolean o1State = ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o1)).getDataNodeState();
            boolean o2State = ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o2)).getDataNodeState();
            if (!o1State && o2State) {
                return 1;
            }
            if (!o2State && o1State) {
                return -1;
            }
            int o1ConnectionSize = ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o1)).getConnectionListSize() + ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o1)).getCachedCreatedConnectionSize();
            int o2ConnectionSize = ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o2)).getConnectionListSize() + ((DataNodeCompareInfo)dataNodeCompareInfoMap.get(o2)).getCachedCreatedConnectionSize();
            return o1ConnectionSize - o2ConnectionSize;
        });
        if (hostSpecs.get(0) != null) {
            this.cachedDnList.get(hostSpecs.get(0)).incrementCachedCreatingConnectionSize();
        }
        LOGGER.info(GT.tr("SortDnsByLeastConn:  {0}.", dataNodeCompareInfoMap));
        return hostSpecs;
    }

    public int checkClusterState() {
        Map<HostSpec, Boolean> oldStates = this.cachedDnList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, val -> ((DataNode)val.getValue()).getDataNodeState()));
        Map<HostSpec, Boolean> newStates = this.cachedDnList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, val -> this.checkDnState((HostSpec)val.getKey())));
        HashMap checkResult = new HashMap();
        for (DataNodeChangedState dataNodeChangedState : DataNodeChangedState.values()) {
            checkResult.put(dataNodeChangedState, new ArrayList());
        }
        for (Map.Entry entry : this.cachedDnList.entrySet()) {
            HostSpec hostSpec = (HostSpec)entry.getKey();
            boolean oldState = oldStates.get(hostSpec);
            boolean newState = newStates.get(hostSpec);
            if (oldState && !newState) {
                int removed = this.cachedDnList.get(hostSpec).clearCachedConnections();
                ((List)checkResult.get((Object)DataNodeChangedState.CHANGE_TO_INVALID)).add(hostSpec);
                LOGGER.info(GT.tr("A data node failed, clear cached connections, cluster: {0}, hostSpec: {1}, cached connections: {2}.", this.urlIdentifier, hostSpec.toString(), removed));
                continue;
            }
            if (!oldState && newState) {
                ((List)checkResult.get((Object)DataNodeChangedState.CHANGE_TO_VALID)).add(hostSpec);
                continue;
            }
            if (oldState) {
                ((List)checkResult.get((Object)DataNodeChangedState.KEEP_VALID)).add(hostSpec);
                continue;
            }
            ((List)checkResult.get((Object)DataNodeChangedState.KEEP_INVALID)).add(hostSpec);
        }
        LOGGER.info(GT.tr("Check cluster states in cluster: {0}, result: {1}.", this.urlIdentifier, ((Object)checkResult).toString()));
        if (((List)checkResult.get((Object)DataNodeChangedState.CHANGE_TO_VALID)).size() != 0 && ((List)checkResult.get((Object)DataNodeChangedState.KEEP_VALID)).size() != 0 && LoadBalanceHeartBeating.isQuickAutoBalanceStarted()) {
            this.quickLoadBalance((List)checkResult.get((Object)DataNodeChangedState.KEEP_VALID));
        }
        return ((List)checkResult.get((Object)DataNodeChangedState.KEEP_INVALID)).size() + ((List)checkResult.get((Object)DataNodeChangedState.CHANGE_TO_INVALID)).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDnState(HostSpec hostSpec) {
        List<Properties> list = this.cachedPropertiesList;
        synchronized (list) {
            DataNode dataNode = this.cachedDnList.get(hostSpec);
            if (dataNode == null) {
                return false;
            }
            Iterator<Properties> iterator = this.cachedPropertiesList.iterator();
            while (iterator.hasNext()) {
                Properties properties = iterator.next();
                DataNode.CheckDnStateResult result = dataNode.checkDnStateAndProperties(properties);
                if (DataNode.CheckDnStateResult.DN_VALID.equals((Object)result)) {
                    dataNode.setDataNodeState(true);
                    return true;
                }
                if (DataNode.CheckDnStateResult.DN_INVALID.equals((Object)result)) {
                    dataNode.setDataNodeState(false);
                    return false;
                }
                iterator.remove();
            }
            dataNode.setDataNodeState(false);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int quickLoadBalance(List<HostSpec> validDns) {
        Queue<ConnectionInfo> queue = this.abandonedConnectionList;
        synchronized (queue) {
            this.quickAutoBalanceStartTime = System.currentTimeMillis();
            int removed = 0;
            int total = 0;
            int idle = 0;
            int minReservedConnectionPercentage = !this.enableMinReservedConPerCluster ? this.minReservedConPerDatanode : (!this.enableMinReservedConPerDatanode ? this.minReservedConPerCluster : Math.max(this.minReservedConPerDatanode, this.minReservedConPerCluster));
            for (Map.Entry<HostSpec, DataNode> entry : this.cachedDnList.entrySet()) {
                DataNode dataNode = entry.getValue();
                if (dataNode == null) continue;
                total += dataNode.getCachedConnectionListSize();
            }
            HashSet<ConnectionInfo> removedConnectionList = new HashSet<ConnectionInfo>();
            for (HostSpec hostSpec : validDns) {
                DataNode dataNode = this.cachedDnList.get(hostSpec);
                if (dataNode == null) continue;
                List<ConnectionInfo> idleConnections = dataNode.filterIdleConnections(this.quickAutoBalanceStartTime);
                idle += idleConnections.size();
                int removedConnectionsSize = (int)((double)idleConnections.size() * ((double)(100 - minReservedConnectionPercentage) / 100.0));
                for (int i = 0; i < removedConnectionsSize; ++i) {
                    removedConnectionList.add(idleConnections.get(i));
                    ++removed;
                }
            }
            this.abandonedConnectionList.clear();
            this.abandonedConnectionList.addAll(removedConnectionList);
            this.totalAbandonedConnectionSize = this.abandonedConnectionList.size();
            LOGGER.info(GT.tr("QuickLoadBalancing executes in cluster: {0}, put {1} idle connections into abandonedConnectionList, connections can be closed: {2}, total connection: {3}, minReservedConPerCluster: {4}, minReservedConPerDatanode: {5}.", this.urlIdentifier, removed, idle, total, this.minReservedConPerCluster, this.minReservedConPerDatanode));
            return removed;
        }
    }

    public List<Integer> checkConnectionsValidity() {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (Map.Entry<HostSpec, DataNode> entry : this.cachedDnList.entrySet()) {
            DataNode dataNode = entry.getValue();
            ans.add(dataNode.checkConnectionsValidity());
        }
        return ans;
    }

    public int incrementCachedCreatingConnectionSize(HostSpec hostSpec) {
        if (!this.cachedDnList.containsKey(hostSpec)) {
            LOGGER.error(GT.tr("Can not find hostSpec: {0} in Cluster: {1}.", hostSpec.toString(), this.urlIdentifier));
            return 0;
        }
        DataNode dataNode = this.cachedDnList.get(hostSpec);
        if (dataNode != null) {
            return dataNode.incrementCachedCreatingConnectionSize();
        }
        LOGGER.error(GT.tr("Can not find hostSpec: {0} in Cluster: {1}.", hostSpec.toString(), this.urlIdentifier));
        return 0;
    }

    public int getMinReservedConPerCluster() {
        return this.minReservedConPerCluster;
    }

    public boolean isEnableMinReservedConPerCluster() {
        return this.enableMinReservedConPerCluster;
    }

    public int getMinReservedConPerDatanode() {
        return this.minReservedConPerDatanode;
    }

    public boolean isEnableMinReservedConPerDatanode() {
        return this.enableMinReservedConPerDatanode;
    }

    public int hashCode() {
        return Objects.hash(this.urlIdentifier, this.dns, this.abandonedConnectionList, this.cachedDnList, this.cachedPropertiesList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster that = (Cluster)o;
        return Objects.equals(this.urlIdentifier, that.urlIdentifier) && Objects.equals(this.dns, that.dns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int closeConnections() {
        int closed = 0;
        double ceilError = 0.001;
        int atMost = (int)(Math.ceil(0.2 * (double)this.totalAbandonedConnectionSize) + ceilError);
        Queue<ConnectionInfo> queue = this.abandonedConnectionList;
        synchronized (queue) {
            if (this.abandonedConnectionList.isEmpty()) {
                return closed;
            }
            int oldSize = this.abandonedConnectionList.size();
            while (!this.abandonedConnectionList.isEmpty() && closed < atMost) {
                boolean hasClosed;
                DataNode dataNode;
                ConnectionInfo connectionInfo = this.abandonedConnectionList.poll();
                HostSpec hostSpec = connectionInfo.getHostSpec();
                if (hostSpec == null || !connectionInfo.checkConnectionIsValid() || !connectionInfo.checkConnectionCanBeClosed(this.quickAutoBalanceStartTime) || (dataNode = this.cachedDnList.get(hostSpec)) == null || !(hasClosed = dataNode.closeConnection(connectionInfo.getPgConnection()))) continue;
                ++closed;
            }
            if (this.abandonedConnectionList.isEmpty()) {
                this.quickAutoBalanceStartTime = 0L;
                this.totalAbandonedConnectionSize = 0;
            }
            LOGGER.info(GT.tr("Close connections execute in cluster: {0}, closed connections: {1}, size of abandonedConnectionList before closing: {2}, size of abandonedConnectionList after closing: {3}.", this.urlIdentifier, closed, oldSize, this.abandonedConnectionList.size()));
        }
        return closed;
    }

    public int getCachedConnectionSize() {
        return this.cachedDnList.values().stream().mapToInt(DataNode::getCachedConnectionListSize).sum();
    }

    static enum DataNodeChangedState {
        KEEP_VALID,
        KEEP_INVALID,
        CHANGE_TO_VALID,
        CHANGE_TO_INVALID;

    }

    class DataNodeCompareInfo {
        int connectionListSize;
        int cachedCreatedConnectionSize;
        boolean dataNodeState;

        public DataNodeCompareInfo(int connectionListSize, int cachedCreatedConnectionSize, boolean dataNodeState) {
            this.connectionListSize = connectionListSize;
            this.cachedCreatedConnectionSize = cachedCreatedConnectionSize;
            this.dataNodeState = dataNodeState;
        }

        public int getConnectionListSize() {
            return this.connectionListSize;
        }

        public int getCachedCreatedConnectionSize() {
            return this.cachedCreatedConnectionSize;
        }

        public boolean getDataNodeState() {
            return this.dataNodeState;
        }

        public String toString() {
            return "{connectionListSize=" + this.connectionListSize + ", cachedCreatedConnectionSize=" + this.cachedCreatedConnectionSize + ", dataNodeState=" + this.dataNodeState + '}';
        }
    }
}

