/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentException;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.annotation.pageannot.AnnPage;
import org.ofdrw.core.annotation.pageannot.PageAnnot;
import org.ofdrw.core.attachment.Attachments;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.doc.CT_CommonData;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.pageObj.CT_TemplatePage;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.Template;
import org.ofdrw.core.basicStructure.pageObj.layer.Type;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.signatures.Signature;
import org.ofdrw.core.signatures.Signatures;
import org.ofdrw.gm.ses.parse.SESVersionHolder;
import org.ofdrw.gm.ses.parse.VersionParser;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.BadOFDException;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.ResourceManage;
import org.ofdrw.reader.ZipUtil;
import org.ofdrw.reader.model.AnnotionEntity;
import org.ofdrw.reader.model.StampAnnotEntity;
import org.ofdrw.reader.model.TemplatePageEntity;

public class OFDReader
implements Closeable {
    private Path workDir;
    private OFDDir ofdDir;
    protected ResourceLocator rl;
    private boolean closed = false;
    private ResourceManage resMgt;

    private OFDReader() {
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public OFDReader(Path ofdFile) throws IOException {
        if (ofdFile == null || Files.notExists(ofdFile, new LinkOption[0])) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4f4d\u7f6e(ofdFile)\u4e0d\u6b63\u786e");
        }
        this.workDir = Files.createTempDirectory("ofd-tmp-", new FileAttribute[0]);
        ZipUtil.unZipFiles(ofdFile.toFile(), this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        this.resMgt = new ResourceManage(this);
    }

    public OFDReader(String ofdFileLoc) throws IOException {
        this(Paths.get(ofdFileLoc, new String[0]));
    }

    public OFDReader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8f93\u5165\u6d41(stream)\u4e0d\u6b63\u786e");
        }
        this.workDir = Files.createTempDirectory("ofd-tmp-", new FileAttribute[0]);
        ZipUtil.unZipFiles(stream, this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        this.resMgt = new ResourceManage(this);
    }

    public OFDReader(String unzippedPathRoot, boolean deleteOnClose) {
        this.workDir = Paths.get(unzippedPathRoot, new String[0]);
        if (Files.notExists(this.workDir, new LinkOption[0]) || !Files.isDirectory(this.workDir, new LinkOption[0])) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4f4d\u7f6e(unzippedPathRoot)\u4e0d\u6b63\u786e");
        }
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
        if (!deleteOnClose) {
            this.closed = true;
        }
        this.resMgt = new ResourceManage(this);
    }

    public OFDDir getOFDDir() {
        return this.ofdDir;
    }

    public ST_Loc getDefaultDocSignaturesPath() {
        try {
            this.rl.save();
            this.rl.cd("/");
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc loc = docBody.getSignatures();
            if (loc == null) {
                ST_Loc sT_Loc = null;
                return sT_Loc;
            }
            String signListFileAbsPath = this.rl.toAbsolutePath(loc);
            ST_Loc sT_Loc = ST_Loc.getInstance((String)signListFileAbsPath);
            return sT_Loc;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
        finally {
            this.rl.restore();
        }
    }

    public Signatures getDefaultSignatures() {
        ST_Loc signaturesLoc = this.getDefaultDocSignaturesPath();
        if (signaturesLoc == null || !this.rl.exist(signaturesLoc.toString())) {
            return null;
        }
        try {
            return this.rl.get(signaturesLoc, Signatures::new);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public boolean hasSignature() {
        DocBody docBody = null;
        try {
            docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc signaturesLoc = docBody.getSignatures();
            return signaturesLoc != null;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public Annotations getAnnotations() {
        try {
            Document document = this.cdDefaultDoc();
            ST_Loc annotations = document.getAnnotations();
            if (annotations == null || !this.rl.exist(annotations.toString())) {
                Annotations annotations2 = null;
                return annotations2;
            }
            Annotations annotations3 = this.rl.get(annotations, Annotations::new);
            return annotations3;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public int getNumberOfPages() {
        try {
            Document document = this.cdDefaultDoc();
            Pages pages = document.getPages();
            int n = pages.getSize();
            return n;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public PageInfo getPageInfo(int pageNum) {
        if (pageNum <= 0) {
            throw new NumberFormatException("\u9875\u7801(pageNum)\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        try {
            this.rl.save();
            int index = pageNum - 1;
            Document document = this.cdDefaultDoc();
            Pages pages = document.getPages();
            List pageList = pages.getPages();
            if (index >= pageList.size()) {
                throw new NumberFormatException(pageNum + "\u8d85\u8fc7\u6700\u5927\u9875\u7801:" + pageList.size());
            }
            ST_Loc pageLoc = ((org.ofdrw.core.basicStructure.pageTree.Page)pageList.get(index)).getBaseLoc();
            Page obj = this.rl.get(pageLoc, Page::new);
            pageLoc = this.rl.getAbsTo(pageLoc);
            ST_Box pageSize = this.getPageSize(obj);
            ArrayList<TemplatePageEntity> templatePages = new ArrayList<TemplatePageEntity>();
            for (Template item : obj.getTemplates()) {
                TemplatePageEntity template = this.getTemplate(item.getTemplateID().toString());
                Type type = Type.getInstance((String)item.attributeValue("ZOrder"));
                template.setOrder(type);
                templatePages.add(template);
            }
            int n = index;
            String pageNName = new ST_Loc(pageLoc.parent()).getFileName().toLowerCase();
            if (pageNName.matches("page_\\d+")) {
                try {
                    n = Integer.parseInt(pageNName.replace("page_", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PageInfo pageInfo = new PageInfo().setIndex(pageNum).setId(((org.ofdrw.core.basicStructure.pageTree.Page)pageList.get(index)).getID()).setObj(obj).setSize(pageSize.clone()).setPageAbsLoc(pageLoc).setTemplates(templatePages).setPageN(n);
            return pageInfo;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public List<PageInfo> getPageList() {
        int numberOfPages = this.getNumberOfPages();
        ArrayList<PageInfo> res = new ArrayList<PageInfo>(numberOfPages);
        for (int i = 0; i < numberOfPages; ++i) {
            PageInfo pageInfo = this.getPageInfo(i + 1);
            res.add(pageInfo);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplatePageEntity getTemplate(String id) {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        try {
            Document document = this.cdDefaultDoc();
            CT_CommonData commonData = document.getCommonData();
            TemplatePageEntity res = null;
            for (CT_TemplatePage item : commonData.getTemplatePages()) {
                String itemId = item.getID().toString();
                if (!id.equals(itemId)) continue;
                ST_Loc loc = item.getBaseLoc();
                if (loc == null) break;
                Page page = this.rl.get(loc, Page::new);
                res = new TemplatePageEntity(item, page);
                break;
            }
            Iterator iterator = res;
            return iterator;
        }
        catch (FileNotFoundException | DocumentException e) {
            TemplatePageEntity templatePageEntity = null;
            return templatePageEntity;
        }
        finally {
            this.rl.restore();
        }
    }

    public Document cdDoc(int numOfDoc) throws DocumentException, FileNotFoundException {
        this.rl.save();
        this.rl.cd("/");
        DocBody docBody = this.ofdDir.getOfd().getDocBody(numOfDoc);
        ST_Loc docRoot = docBody.getDocRoot();
        Document document = this.rl.get(docRoot, Document::new);
        this.rl.cd(docRoot.parent());
        return document;
    }

    public Document cdDefaultDoc() throws DocumentException, FileNotFoundException {
        return this.cdDoc(0);
    }

    public ST_Box getPageSize(Page page) {
        if (page == null) {
            return null;
        }
        CT_PageArea pageArea = page.getArea();
        if (pageArea == null || pageArea.getBox() == null) {
            CT_PageArea tplArea = null;
            int biggestOrder = -1;
            for (Template item : page.getTemplates()) {
                TemplatePageEntity template = this.getTemplate(item.getTemplateID().toString());
                if (template == null || template.getPage() == null) continue;
                CT_PageArea area = template.getPage().getArea();
                int order = template.getZOrder().order();
                if (area == null || order <= biggestOrder || area.getBox() == null) continue;
                tplArea = area;
                biggestOrder = order;
            }
            pageArea = tplArea;
            if (pageArea == null) {
                Document document;
                try {
                    document = this.ofdDir.obtainDocDefault().getDocument();
                }
                catch (FileNotFoundException | DocumentException e) {
                    throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
                }
                CT_CommonData commonData = document.getCommonData();
                pageArea = commonData.getPageArea();
            }
        }
        if (pageArea == null) {
            return null;
        }
        return pageArea.getBox();
    }

    public Page getPage(int pageNum) {
        return this.getPageInfo(pageNum).getObj();
    }

    public ST_ID getPageObjectId(int pageNum) {
        return this.getPageInfo(pageNum).getId();
    }

    public ResourceLocator getResourceLocator() {
        return this.rl;
    }

    public CT_Attachment getAttachment(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment cT_Attachment = this.getAttachment(name, this.rl);
            return cT_Attachment;
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getAttachmentFile(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment attachment = this.getAttachment(name, this.rl);
            if (attachment == null) {
                Path path = null;
                return path;
            }
            ST_Loc fileLoc = attachment.getFileLoc();
            try {
                Path path = this.rl.getFile(fileLoc);
                return path;
            }
            catch (FileNotFoundException e) {
                System.err.println(">> \u65e0\u6cd5\u6839\u636e\u9644\u4ef6\u5bf9\u8c61\u7684\u63cf\u8ff0\u83b7\u53d6\u5230\u9644\u4ef6: " + fileLoc.toString());
                Path path = null;
                this.rl.restore();
                return path;
            }
        }
        finally {
            this.rl.restore();
        }
    }

    private CT_Attachment getAttachment(String name, ResourceLocator rl) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        DocDir docDir = this.ofdDir.obtainDocDefault();
        rl.cd((VirtualContainer)docDir);
        Document document = null;
        Attachments attachments = null;
        try {
            document = docDir.getDocument();
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException(e);
        }
        ST_Loc attachmentsLoc = document.getAttachments();
        if (attachmentsLoc == null || !rl.exist(attachmentsLoc.toString())) {
            return null;
        }
        try {
            attachments = rl.get(attachmentsLoc, Attachments::new);
        }
        catch (FileNotFoundException | DocumentException e) {
            System.err.println(">> \u65e0\u6cd5\u83b7\u53d6\u6216\u89e3\u6790Attachments.xml: " + e.getMessage());
            return null;
        }
        String parent = attachmentsLoc.parent();
        if (parent != null) {
            rl.cd(parent);
        }
        for (CT_Attachment attachment : attachments.getAttachments()) {
            if (!attachment.getAttachmentName().equals(name)) continue;
            return attachment;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StampAnnotEntity> getStampAnnots() {
        if (!this.hasSignature()) {
            return Collections.emptyList();
        }
        try {
            this.rl.save();
            Signatures sigFileList = this.getDefaultSignatures();
            if (sigFileList == null) {
                List<StampAnnotEntity> list = Collections.emptyList();
                return list;
            }
            ST_Loc signaturesLoc = this.getDefaultDocSignaturesPath();
            this.rl.cd(signaturesLoc.parent());
            List sigInfoList = sigFileList.getSignatures();
            ArrayList<StampAnnotEntity> res = new ArrayList<StampAnnotEntity>(sigInfoList.size());
            for (Signature sigInfoItem : sigInfoList) {
                ST_Loc signatureBaseLoc = sigInfoItem.getBaseLoc();
                this.rl.save();
                try {
                    org.ofdrw.core.signatures.sig.Signature sigDesp = this.rl.get(signatureBaseLoc, org.ofdrw.core.signatures.sig.Signature::new);
                    try {
                        this.rl.cd(signatureBaseLoc.parent());
                        ST_Loc signedValueLoc = sigDesp.getSignedValue();
                        this.rl.cd(signedValueLoc.parent());
                        Path signedValueFile = this.rl.getFile(signedValueLoc);
                        SESVersionHolder v = VersionParser.parseSES_SignatureVersion((Object)Files.readAllBytes(signedValueFile));
                        res.add(new StampAnnotEntity(v, sigDesp.getSignedInfo()));
                    }
                    finally {
                        this.rl.restore();
                    }
                }
                catch (Exception exception) {}
            }
            ArrayList<StampAnnotEntity> arrayList = res;
            return arrayList;
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AnnotionEntity> getAnnotationEntities() {
        ArrayList<AnnotionEntity> arrayList;
        Document document = this.cdDefaultDoc();
        ST_Loc annInfosLoc = document.getAnnotations();
        if (annInfosLoc == null || !this.rl.exist(annInfosLoc.toString())) {
            return Collections.emptyList();
        }
        Annotations annotations = this.rl.get(annInfosLoc, Annotations::new);
        if (annotations == null) {
            return Collections.emptyList();
        }
        this.rl.cd(annInfosLoc.parent());
        try {
            List annPages = annotations.getPages();
            ArrayList<AnnotionEntity> res = new ArrayList<AnnotionEntity>(annPages.size());
            for (AnnPage annPage : annPages) {
                try {
                    ST_Loc fileLoc = annPage.getFileLoc();
                    PageAnnot pageAnnot = this.rl.get(fileLoc, PageAnnot::new);
                    res.add(new AnnotionEntity(annPage.getPageID().toString(), pageAnnot.getAnnots()));
                }
                catch (Exception exception) {}
            }
            arrayList = res;
            this.rl.restore();
        }
        catch (Throwable throwable) {
            try {
                this.rl.restore();
                throw throwable;
            }
            catch (FileNotFoundException | DocumentException e) {
                throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
            }
        }
        return arrayList;
    }

    public ResourceManage getResMgt() {
        return this.resMgt;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.workDir != null && Files.exists(this.workDir, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)this.workDir.toFile());
            }
            catch (IOException e) {
                throw new IOException("\u65e0\u6cd5\u5220\u9664Reader\u7684\u5de5\u4f5c\u7a7a\u95f4\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
            }
        }
    }
}

