/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.nutz.dao;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.sf.ehcache.CacheManager;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.jdbc.DataSourceStarter;
import org.nutz.dao.SqlManager;
import org.nutz.dao.impl.DaoRunner;
import org.nutz.dao.impl.FileSqlManager;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.sql.run.NutDaoRunner;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Regex;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.DaoCacheInterceptor;
import org.nutz.plugins.cache.dao.api.CacheSerializer;
import org.nutz.plugins.cache.dao.api.DaoCacheProvider;
import org.nutz.plugins.cache.dao.impl.convert.JavaCacheSerializer;
import org.nutz.plugins.cache.dao.impl.provider.AbstractDaoCacheProvider;
import org.nutz.plugins.cache.dao.impl.provider.EhcacheDaoCacheProvider;
import org.nutz.plugins.cache.dao.impl.provider.MemoryDaoCacheProvider;
import org.nutz.plugins.cache.dao.impl.provider.RedisDaoCacheProvider;
import redis.clients.jedis.JedisPool;

@IocBean(create="init")
public class NutDaoStarter {
    private static final Log log = Logs.get();
    protected static final String PRE = "nutz.dao.";
    @PropDoc(value="\u662f\u5426\u6253\u5370dao\u7684SQL\u65e5\u5fd7", defaultValue="true", type="boolean")
    public static final String PROP_INTERCEPTOR_LOG_ENABLE = "nutz.dao.interceptor.log.enable";
    @PropDoc(value="\u662f\u5426\u6253\u5370dao\u7684SQL\u8017\u65f6\u65e5\u5fd7", defaultValue="false", type="boolean")
    public static final String PROP_INTERCEPTOR_TIME_ENABLE = "nutz.dao.interceptor.time.enable";
    @PropDoc(value="sql\u76ee\u5f55", defaultValue="sqls/")
    public static final String PROP_SQLS_PATH = "nutz.dao.sqls.path";
    @PropDoc(value="\u662f\u5426\u4f7f\u7528daocache", defaultValue="false", type="boolean")
    public static final String PROP_INTERCEPTOR_CACHE_ENABLE = "nutz.dao.interceptor.cache.enable";
    @PropDoc(value="daocache\u63d0\u4f9b\u8005", defaultValue="memory", possible={"memory", "ehcache", "jedis", "ioc"})
    public static final String PROP_INTERCEPTOR_CACHE_PROVIDER_TYPE = "nutz.dao.interceptor.cache.provider.type";
    @PropDoc(value="daocache\u63d0\u4f9b\u8005MemoryDaoCacheProvider\u7684\u9ed8\u8ba4\u7f13\u5b58\u5927\u5c0f")
    public static final String PROP_INTERCEPTOR_CACHE_PROVIDER_MEMORY_CACHE_SIZE = "nutz.dao.interceptor.cache.provider.memory.cacheSize";
    @PropDoc(value="daocache\u63d0\u4f9b\u8005DaoCacheProvider\u7684IocBean\u540d\u79f0", defaultValue="daoCacheProvider")
    public static final String PROP_INTERCEPTOR_CACHE_PROVIDER_IOC_NAME = "nutz.dao.interceptor.cache.provider.ioc.name";
    @PropDoc(value="\u9700\u8981\u7f13\u5b58\u7684\u8868\u540d\u79f0,\u82f1\u6587\u9017\u53f7\u5206\u9694")
    public static final String PROP_INTERCEPTOR_CACHE_TABLE_NAMES = "nutz.dao.interceptor.cache.table.names";
    @PropDoc(value="\u9700\u8981\u7f13\u5b58\u7684\u8868\u540d\u79f0\u7684\u6b63\u5219\u8868\u8fbe\u5f0f")
    public static final String PROP_INTERCEPTOR_CACHE_TABLE_PATTERN = "nutz.dao.interceptor.cache.table.pattern";
    @PropDoc(value="\u6253\u5370daocache\u8be6\u7ec6\u8c03\u8bd5\u65e5\u5fd7", defaultValue="false", type="boolean")
    public static final String PROP_INTERCEPTOR_CACHE_DEBUG = "nutz.dao.interceptor.cache.debug";
    @PropDoc(value="\u4e8b\u52a1\u5185\u662f\u5426\u542f\u7528daocache", defaultValue="false", type="boolean")
    public static final String PROP_INTERCEPTOR_CACHE_ENABLE_WHEN_TRANS = "nutz.dao.interceptor.cache.enableWhenTrans";
    @PropDoc(value="\u662f\u5426\u7f13\u5b58null\u7ed3\u679c", defaultValue="true", type="boolean")
    public static final String PROP_INTERCEPTOR_CACHE_CACHE4NULL = "nutz.dao.interceptor.cache.cache4Null";
    @Inject
    protected PropertiesProxy conf;
    @Inject(value="refer:$ioc")
    protected Ioc ioc;

    public void init() {
        this.injectManyDao();
    }

    @IocBean
    public SqlManager getSqlManager() {
        return new FileSqlManager(new String[]{this.conf.get(PROP_SQLS_PATH, "sqls/")});
    }

    @IocBean(name="daoCacheSerializer")
    public CacheSerializer createCacheSerializer() {
        return new JavaCacheSerializer();
    }

    @IocBean(name="daoCacheInterceptor")
    public DaoCacheInterceptor createDaoCacheInterceptor() {
        String[] daoCacheProviderType;
        DaoCacheInterceptor daoCacheInterceptor = new DaoCacheInterceptor();
        EhcacheDaoCacheProvider provider = null;
        switch (daoCacheProviderType = this.conf.get(PROP_INTERCEPTOR_CACHE_PROVIDER_TYPE, "memory")) {
            case "ehcache": {
                EhcacheDaoCacheProvider _provider = new EhcacheDaoCacheProvider();
                _provider.setCacheManager((CacheManager)this.getCacheManager());
                provider = _provider;
                break;
            }
            case "jedis": {
                EhcacheDaoCacheProvider _provider = new RedisDaoCacheProvider();
                _provider.setJedisPool((JedisPool)this.ioc.get(JedisPool.class));
                provider = _provider;
                break;
            }
            case "ioc": {
                provider = (DaoCacheProvider)this.ioc.get(DaoCacheProvider.class, this.conf.get(PROP_INTERCEPTOR_CACHE_PROVIDER_IOC_NAME, "daoCacheProvider"));
                break;
            }
            default: {
                log.warnf("not supprt [%s], fallback to memory", new Object[]{daoCacheProviderType});
            }
            case "memory": {
                EhcacheDaoCacheProvider _provider = new MemoryDaoCacheProvider();
                if (this.conf.has(PROP_INTERCEPTOR_CACHE_PROVIDER_MEMORY_CACHE_SIZE)) {
                    _provider.setCacheSize(this.conf.getInt(PROP_INTERCEPTOR_CACHE_PROVIDER_MEMORY_CACHE_SIZE));
                }
                provider = _provider;
                break;
            }
        }
        if (provider instanceof AbstractDaoCacheProvider) {
            ((AbstractDaoCacheProvider)provider).setSerializer((CacheSerializer)this.ioc.get(CacheSerializer.class, "daoCacheSerializer"));
        }
        for (String tableName : Strings.splitIgnoreBlank((String)this.conf.get(PROP_INTERCEPTOR_CACHE_TABLE_NAMES, ""))) {
            daoCacheInterceptor.addCachedTableName(Strings.trim((CharSequence)tableName));
        }
        if (this.conf.has(PROP_INTERCEPTOR_CACHE_TABLE_PATTERN)) {
            daoCacheInterceptor.setCachedTableNamePatten(this.conf.get(PROP_INTERCEPTOR_CACHE_TABLE_PATTERN));
        }
        if (this.conf.getBoolean(PROP_INTERCEPTOR_CACHE_ENABLE_WHEN_TRANS)) {
            daoCacheInterceptor.setEnableWhenTrans(true);
        }
        if (this.conf.getBoolean(PROP_INTERCEPTOR_CACHE_DEBUG, false)) {
            DaoCacheInterceptor.DEBUG = true;
        }
        daoCacheInterceptor.setCache4Null(this.conf.getBoolean(PROP_INTERCEPTOR_CACHE_CACHE4NULL, true));
        daoCacheInterceptor.setCacheProvider((DaoCacheProvider)provider);
        return daoCacheInterceptor;
    }

    @IocBean(name="dao")
    public NutDao getDao(@Inject DataSource dataSource, @Inject SqlManager sqlManager) {
        DataSource slaveDataSource;
        NutDao dao = new NutDao(dataSource, sqlManager);
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (this.conf.getBoolean(PROP_INTERCEPTOR_CACHE_ENABLE, false)) {
            interceptors.add(this.ioc.get(DaoCacheInterceptor.class));
        }
        if (this.conf.getBoolean(PROP_INTERCEPTOR_LOG_ENABLE, true)) {
            interceptors.add("log");
        }
        if (this.conf.getBoolean(PROP_INTERCEPTOR_TIME_ENABLE, true)) {
            interceptors.add("time");
        }
        dao.setInterceptors(interceptors);
        if (Lang.loadClassQuite((String)"org.nutz.boot.starter.jdbc.DataSourceStarter") != null && (slaveDataSource = DataSourceStarter.getSlaveDataSource((Ioc)this.ioc, (PropertiesProxy)this.conf, (String)"jdbc.slave.")) != null) {
            NutDaoRunner runner = new NutDaoRunner();
            runner.setSlaveDataSource(slaveDataSource);
            dao.setRunner((DaoRunner)runner);
        }
        return dao;
    }

    private void injectManyDao() {
        String regex = "jdbc\\.many\\.(\\w*)\\.url";
        for (String key : this.conf.getKeys()) {
            Pattern pattern = Regex.getPattern((String)regex);
            Matcher match = pattern.matcher(key);
            if (!match.find()) continue;
            String name = match.group(1);
            String prefix_name = "jdbc.many." + name + ".";
            try {
                DataSource manyDataSource = DataSourceStarter.createManyDataSource((Ioc)this.ioc, (PropertiesProxy)this.conf, (String)prefix_name);
                NutDao nutDao = new NutDao();
                nutDao.setDataSource(manyDataSource);
                String slave_prefix = prefix_name + "slave.";
                DataSource slaveDataSource = DataSourceStarter.getManySlaveDataSource((Ioc)this.ioc, (PropertiesProxy)this.conf, (String)slave_prefix);
                if (slaveDataSource != null) {
                    NutDaoRunner runner = new NutDaoRunner();
                    runner.setSlaveDataSource(slaveDataSource);
                    nutDao.setRunner((DaoRunner)runner);
                }
                this.ioc.addBean(name + "Dao", (Object)nutDao);
            }
            catch (Exception e) {
                throw new RuntimeException("datasource init error " + prefix_name, e);
            }
        }
    }

    protected Object getCacheManager() {
        CacheManager cacheManager = CacheManager.getInstance();
        if (cacheManager != null) {
            return cacheManager;
        }
        return CacheManager.newInstance();
    }
}

