/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.jetty;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.MonitorObject;
import org.nutz.boot.starter.ServerFace;
import org.nutz.boot.starter.servlet3.AbstractServletContainerStarter;
import org.nutz.boot.starter.servlet3.NbServletContextListener;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;

@IocBean
public class JettyStarter
extends AbstractServletContainerStarter
implements ServerFace,
MonitorObject {
    private static final Log log = Logs.get();
    protected static final String PRE = "jetty.";
    @PropDoc(value="\u76d1\u542c\u7684\u7aef\u53e3", defaultValue="8080", type="int")
    public static final String PROP_PORT = "jetty.port";
    @PropDoc(value="\u76d1\u542c\u7684ip\u5730\u5740", defaultValue="0.0.0.0")
    public static final String PROP_HOST = "jetty.host";
    @PropDoc(value="\u7ebf\u7a0b\u6c60idleTimeout\uff0c\u5355\u4f4d\u6beb\u79d2", defaultValue="60000", type="int")
    public static final String PROP_THREADPOOL_TIMEOUT = "jetty.threadpool.idleTimeout";
    @PropDoc(value="\u7ebf\u7a0b\u6c60\u6700\u5c0f\u7ebf\u7a0b\u6570minThreads", defaultValue="200", type="int")
    public static final String PROP_THREADPOOL_MINTHREADS = "jetty.threadpool.minThreads";
    @PropDoc(value="\u7ebf\u7a0b\u6c60\u6700\u5927\u7ebf\u7a0b\u6570maxThreads", defaultValue="500", type="int")
    public static final String PROP_THREADPOOL_MAXTHREADS = "jetty.threadpool.maxThreads";
    @PropDoc(value="\u7a7a\u95f2\u65f6\u95f4,\u5355\u4f4d\u6beb\u79d2", defaultValue="300000", type="int")
    public static final String PROP_IDLE_TIMEOUT = "jetty.http.idleTimeout";
    @PropDoc(value="\u4e0a\u4e0b\u6587\u8def\u5f84", defaultValue="/")
    public static final String PROP_CONTEXT_PATH = "jetty.contextPath";
    @PropDoc(value="\u8868\u5355\u6700\u5927\u5c3a\u5bf8", defaultValue="1gb", type="int")
    public static final String PROP_MAX_FORM_CONTENT_SIZE = "jetty.maxFormContentSize";
    @PropDoc(value="Session\u7a7a\u95f2\u65f6\u95f4,\u5355\u4f4d\u5206\u949f", defaultValue="30", type="int")
    public static final String PROP_SESSION_TIMEOUT = "web.session.timeout";
    @PropDoc(value="\u9759\u6001\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u5f84")
    public static final String PROP_STATIC_PATH_LOCAL = "jetty.staticPathLocal";
    @PropDoc(value="\u989d\u5916\u7684\u9759\u6001\u6587\u4ef6\u8def\u5f84")
    public static final String PROP_STATIC_PATH = "jetty.staticPath";
    @PropDoc(value="\u5b89\u5168\u534f\u8bae,\u4f8b\u5982https")
    public static final String PROP_HTTP_CONFIG_SECURESCHEME = "jetty.httpConfig.secureScheme";
    @PropDoc(value="\u5b89\u5168\u534f\u8bae\u7684\u7aef\u53e3,\u4f8b\u59828443")
    public static final String PROP_HTTP_CONFIG_SECUREPORT = "jetty.httpConfig.securePort";
    @PropDoc(value="\u8f93\u51fa\u7f13\u51b2\u533a\u5927\u5c0f", defaultValue="32768")
    public static final String PROP_HTTP_CONFIG_OUTPUTBUFFERSIZE = "jetty.httpConfig.outputBufferSize";
    @PropDoc(value="\u8f93\u51fa\u805a\u5408\u5927\u5c0f", defaultValue="8192")
    public static final String PROP_HTTP_CONFIG_OUTPUTAGGREGATIONSIZE = "jetty.httpConfig.outputAggregationSize";
    @PropDoc(value="\u8bf7\u6c42\u7684\u5934\u90e8\u6700\u5927\u503c", defaultValue="8192")
    public static final String PROP_HTTP_CONFIG_REQUESTHEADERSIZE = "jetty.httpConfig.requestHeaderSize";
    @PropDoc(value="\u54cd\u5e94\u7684\u5934\u90e8\u6700\u5927\u503c", defaultValue="8192")
    public static final String PROP_HTTP_CONFIG_RESPONSEHEADERSIZE = "jetty.httpConfig.responseHeaderSize";
    @PropDoc(value="\u662f\u5426\u53d1\u9001jetty\u7248\u672c\u53f7", defaultValue="true")
    public static final String PROP_HTTP_CONFIG_SENDSERVERVERSION = "jetty.httpConfig.sendServerVersion";
    @PropDoc(value="\u662f\u5426\u53d1\u9001\u65e5\u671f\u4fe1\u606f", defaultValue="true")
    public static final String PROP_HTTP_CONFIG_SENDDATEHEADER = "jetty.httpConfig.sendDateHeader";
    @PropDoc(value="\u5934\u90e8\u7f13\u51b2\u533a\u5927\u5c0f", defaultValue="8192")
    public static final String PROP_HTTP_CONFIG_HEADERCACHESIZE = "jetty.httpConfig.headerCacheSize";
    @PropDoc(value="\u6700\u5927\u9519\u8bef\u91cd\u5b9a\u5411\u6b21\u6570", defaultValue="10")
    public static final String PROP_HTTP_CONFIG_MAXERRORDISPATCHES = "jetty.httpConfig.maxErrorDispatches";
    @PropDoc(value="\u963b\u585e\u8d85\u65f6", defaultValue="-1")
    public static final String PROP_HTTP_CONFIG_BLOCKINGTIMEOUT = "jetty.httpConfig.blockingTimeout";
    @PropDoc(value="\u662f\u5426\u542f\u7528\u6301\u4e45\u5316\u8fde\u63a5", defaultValue="true")
    public static final String PROP_HTTP_CONFIG_PERSISTENTCONNECTIONSENABLED = "jetty.httpConfig.persistentConnectionsEnabled";
    @PropDoc(value="\u81ea\u5b9a\u4e49404\u9875\u9762,\u540c\u7406,\u5176\u4ed6\u72b6\u6001\u7801\u4e5f\u662f\u652f\u6301\u7684")
    public static final String PROP_PAGE_404 = "jetty.page.404";
    @PropDoc(value="\u81ea\u5b9a\u4e49java.lang.Throwable\u9875\u9762,\u540c\u7406,\u5176\u4ed6\u5f02\u5e38\u4e5f\u652f\u6301")
    public static final String PROP_PAGE_THROWABLE = "jetty.page.java.lang.Throwable";
    @PropDoc(value="\u662f\u5426\u542f\u7528gzip", defaultValue="false")
    public static final String PROP_GZIP_ENABLE = "jetty.gzip.enable";
    @PropDoc(value="gzip\u538b\u7f29\u7ea7\u522b", defaultValue="-1")
    public static final String PROP_GZIP_LEVEL = "jetty.gzip.level";
    @PropDoc(value="gzip\u538b\u7f29\u6700\u5c0f\u89e6\u53d1\u5927\u5c0f", defaultValue="512")
    public static final String PROP_GZIP_MIN_CONTENT_SIZE = "jetty.gzip.minContentSize";
    @PropDoc(value="WelcomeFile\u5217\u8868", defaultValue="index.html,index.htm,index.do")
    public static final String PROP_WELCOME_FILES = "jetty.welcome_files";
    @PropDoc(value="Https\u7aef\u53e3\u53f7")
    public static final String PROP_HTTPS_PORT = "jetty.https.port";
    @PropDoc(value="Https\u7684KeyStore\u8def\u5f84")
    public static final String PROP_HTTPS_KEYSTORE_PATH = "jetty.https.keystore.path";
    @PropDoc(value="Https\u7684KeyStore\u7684\u5bc6\u7801")
    public static final String PROP_HTTPS_KEYSTORE_PASSWORD = "jetty.https.keystore.password";
    protected Server server;
    protected WebAppContext wac;
    protected ServerConnector connector;

    public void start() throws Exception {
        this.server.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Jetty monitor props:\r\n" + this.getMonitorForPrint()));
        }
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    @IocBean(name="jettyServer")
    public Server getJettyServer() {
        return this.server;
    }

    public void init() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setIdleTimeout(this.getThreadPoolIdleTimeout());
        threadPool.setMinThreads(this.getMinThreads());
        threadPool.setMaxThreads(this.getMaxThreads());
        this.server = new Server((ThreadPool)threadPool);
        HttpConfiguration httpConfig = (HttpConfiguration)this.conf.make(HttpConfiguration.class, "jetty.httpConfig.");
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        this.connector = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
        this.connector.setHost(this.getHost());
        this.connector.setPort(this.getPort());
        this.connector.setIdleTimeout((long)this.getIdleTimeout());
        this.server.addConnector((Connector)this.connector);
        this.updateMonitorValue("http.port", this.connector.getPort());
        this.updateMonitorValue("http.host", this.connector.getHost());
        this.updateMonitorValue("http.idleTimeout", this.connector.getIdleTimeout());
        int httpsPort = this.conf.getInt(PROP_HTTPS_PORT);
        if (httpsPort > 0) {
            log.info((Object)("found https port " + httpsPort));
            HttpConfiguration https_config = (HttpConfiguration)this.conf.make(HttpConfiguration.class, "jetty.httpsConfig.");
            https_config.setSecureScheme("https");
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.conf.get(PROP_HTTPS_KEYSTORE_PATH));
            sslContextFactory.setKeyStorePassword(this.conf.get(PROP_HTTPS_KEYSTORE_PASSWORD));
            sslContextFactory.setKeyManagerPassword(this.conf.get("jetty.https.keymanager.password"));
            ServerConnector httpsConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
            httpsConnector.setPort(httpsPort);
            httpsConnector.setHost(this.getHost());
            httpsConnector.setIdleTimeout((long)this.getIdleTimeout());
            this.server.addConnector((Connector)httpsConnector);
            this.updateMonitorValue("https.enable", true);
            this.updateMonitorValue("https.port", httpsConnector.getPort());
            this.updateMonitorValue("https.host", httpsConnector.getHost());
            this.updateMonitorValue("https.idleTimeout", httpsConnector.getIdleTimeout());
        } else {
            this.updateMonitorValue("https.enable", false);
        }
        this.wac = new WebAppContext();
        this.wac.setContextPath(this.getContextPath());
        this.wac.setTempDirectory(new File("temp"));
        this.wac.setClassLoader(this.classLoader);
        this.wac.setConfigurationDiscovered(true);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.wac.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String resourcePath : this.getResourcePaths()) {
            File f = new File(resourcePath);
            if (f.exists()) {
                resources.add(Resource.newResource((File)f));
            }
            Enumeration<URL> urls = this.appContext.getClassLoader().getResources(resourcePath);
            while (urls.hasMoreElements()) {
                resources.add(Resource.newResource((URL)urls.nextElement()));
            }
        }
        if (resources.isEmpty()) {
            resources.add(Resource.newClassPathResource((String)"META-INF/jetty_resources"));
        }
        if (this.conf.has(PROP_STATIC_PATH_LOCAL)) {
            File f = new File(this.conf.get(PROP_STATIC_PATH_LOCAL));
            if (f.exists()) {
                log.debug((Object)("found static local path, add it : " + f.getAbsolutePath()));
                resources.add(0, Resource.newResource((File)f));
            } else {
                log.debug((Object)("static local path not exist, skip it : " + f.getPath()));
            }
        }
        this.wac.setBaseResource((Resource)new ResourceCollection(resources.toArray(new Resource[resources.size()])){

            public Resource addPath(String path) throws IOException, MalformedURLException {
                Resource resource = super.addPath(path);
                if (resource == null && "WEB-INF/".equals(path)) {
                    return Resource.newResource((File)new File("XXXX"));
                }
                return resource;
            }
        });
        if (this.conf.getBoolean(PROP_GZIP_ENABLE, false)) {
            GzipHandler gzip = new GzipHandler();
            gzip.setHandler((Handler)this.wac);
            gzip.setMinGzipSize(this.conf.getInt(PROP_GZIP_MIN_CONTENT_SIZE, 512));
            gzip.setCompressionLevel(this.conf.getInt(PROP_GZIP_LEVEL, -1));
            this.server.setHandler((Handler)gzip);
        } else {
            this.server.setHandler((Handler)this.wac);
        }
        Configuration.ClassList list = Configuration.ClassList.serverDefault((Server)this.server);
        list.add("org.eclipse.jetty.annotations.AnnotationConfiguration");
        list.add("org.eclipse.jetty.webapp.MetaInfConfiguration");
        this.wac.setConfigurationClasses((List)list);
        this.wac.getServletContext().setExtendedListenerTypes(true);
        this.wac.getSessionHandler().setMaxInactiveInterval(this.getSessionTimeout());
        ErrorHandler ep = (ErrorHandler)Lang.first((Collection)this.appContext.getBeans(ErrorHandler.class));
        if (ep == null) {
            ErrorPageErrorHandler handler = new ErrorPageErrorHandler();
            handler.setErrorPages(this.getErrorPages());
            ep = handler;
        }
        this.wac.setErrorHandler(ep);
        this.wac.setWelcomeFiles(this.getWelcomeFiles());
        this.wac.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.updateMonitorValue("welcome_files", Strings.join((String)",", (Object[])this.wac.getWelcomeFiles()));
        this.server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)this.getMaxFormContentSize());
        this.updateMonitorValue("maxFormContentSize", this.server.getAttribute("org.eclipse.jetty.server.Request.maxFormContentSize"));
        this.server.setDumpAfterStart(false);
        this.server.setDumpBeforeStop(false);
        this.server.setStopAtShutdown(true);
        this.addNutzSupport();
        ServerContainer sc = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.wac);
        for (Class klass : Scans.me().scanPackage(this.appContext.getPackage())) {
            if (klass.getAnnotation(ServerEndpoint.class) == null) continue;
            sc.addEndpoint(klass);
        }
    }

    private void addNutzSupport() {
        this.wac.addEventListener((EventListener)this.ioc.get(NbServletContextListener.class));
    }

    public int getMaxFormContentSize() {
        return this.conf.getInt(PROP_MAX_FORM_CONTENT_SIZE, 0x40000000);
    }

    public int getIdleTimeout() {
        return this.conf.getInt(PROP_IDLE_TIMEOUT, 300000);
    }

    public int getMinThreads() {
        return Lang.isAndroid ? 8 : this.conf.getInt(PROP_THREADPOOL_MINTHREADS, 200);
    }

    public int getMaxThreads() {
        return Lang.isAndroid ? 50 : this.conf.getInt(PROP_THREADPOOL_MAXTHREADS, 500);
    }

    public int getThreadPoolIdleTimeout() {
        return this.conf.getInt(PROP_THREADPOOL_TIMEOUT, 60000);
    }

    protected String getConfigurePrefix() {
        return PRE;
    }

    public String getMonitorName() {
        return "jetty";
    }
}

