/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter.fescar;

import com.alibaba.fescar.common.util.StringUtils;
import com.alibaba.fescar.rm.RMClient;
import com.alibaba.fescar.tm.TMClient;
import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.starter.ServerFace;
import org.nutz.boot.starter.fescar.FescarHelper;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

@IocBean
public class FescarStarter
implements ServerFace {
    private static final Log log = Logs.get();
    protected static final String PRE = "fescar.";
    @PropDoc(value="fescar\u662f\u5426\u542f\u7528", defaultValue="false", type="boolean")
    public static String PROP_ENABLED = "fescar.enabled";
    @PropDoc(value="fescar\u5e94\u7528id", need=true)
    public static String PROP_APPID = "fescar.applicationId";
    @PropDoc(value="fescar\u4e8b\u52a1\u7ec4", need=true)
    public static String PROP_TXGROUP = "fescar.txServiceGroup";
    @PropDoc(value="\u81ea\u52a8\u521b\u5efaundo\u8868", defaultValue="true")
    public static String PROP_CREATE_UNDO = "fescar.create_undo_table";
    @Inject
    protected PropertiesProxy conf;
    @Inject
    protected AppContext appContext;
    private String applicationId;
    private String txServiceGroup;

    public void start() throws Exception {
        if (FescarHelper.disableGlobalTransaction) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Global transaction is disabled.");
            }
            return;
        }
        if (!this.conf.getBoolean(PROP_ENABLED, false)) {
            log.info((Object)"Global transaction is disabled.");
            return;
        }
        this.applicationId = this.conf.get(PROP_APPID, this.conf.get("dubbo.application.name", this.conf.get("nutz.application.name", "")));
        if (Strings.isBlank((CharSequence)this.applicationId)) {
            throw Lang.makeThrow((String)"Ioc.$conf expect property '%s'", (Object[])new Object[]{PROP_APPID});
        }
        this.txServiceGroup = this.conf.check(PROP_TXGROUP);
        log.infof("fescar applicationId=%s txServiceGroup=%s", new Object[]{this.applicationId, this.txServiceGroup});
        this.initClient();
    }

    protected void initClient() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty((String)this.applicationId) || StringUtils.isNullOrEmpty((String)this.txServiceGroup)) {
            throw new IllegalArgumentException("applicationId: " + this.applicationId + ", txServiceGroup: " + this.txServiceGroup);
        }
        TMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (log.isInfoEnabled()) {
            log.info((Object)("Transaction Manager Client is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]"));
        }
        RMClient.init((String)this.applicationId, (String)this.txServiceGroup);
        if (log.isInfoEnabled()) {
            log.info((Object)("Resource Manager is initialized. applicationId[" + this.applicationId + "] txServiceGroup[" + this.txServiceGroup + "]"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Global Transaction Clients are initialized. ");
        }
    }
}

