/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.tools;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.boot.AppContext;
import org.nutz.boot.annotation.PropDoc;
import org.nutz.boot.tools.PropDocBean;
import org.nutz.lang.Strings;

public class PropDocReader {
    protected AppContext appContext;
    protected Map<String, PropDocBean> docs = new HashMap<String, PropDocBean>();

    public void load(List<Class<?>> starterClasses) throws Exception {
        for (Class<?> klass : starterClasses) {
            this.addClass(klass);
        }
    }

    public void addClass(Class<?> klass) throws Exception {
        for (Field field : klass.getFields()) {
            PropDoc prop;
            if (!field.getName().startsWith("PROP_") || (prop = field.getAnnotation(PropDoc.class)) == null) continue;
            String key = Strings.isBlank((CharSequence)prop.key()) ? (String)field.get(null) : prop.key();
            PropDocBean doc = new PropDocBean();
            doc.key = key;
            doc.defaultValue = prop.defaultValue();
            doc.value = prop.value();
            doc.group = Strings.isBlank((CharSequence)prop.group()) ? doc.key.substring(0, doc.key.indexOf(46)) : prop.group();
            doc.need = prop.need();
            doc.possible = prop.possible();
            doc.users = new ArrayList<String>();
            this.add(klass.getName(), key, doc);
        }
    }

    public void add(String klassName, String key, PropDocBean newdoc) {
        PropDocBean doc = this.docs.get(key);
        if (doc == null) {
            doc = newdoc;
            this.docs.put(key, doc);
        }
        doc.users.add(klassName);
    }

    public String toMarkdown() {
        String fm = "|%-4s|%-40s|%-10s|%-20s|%-10s|%-20s|%40s|\r\n";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(fm, "id", "key", "required", "Possible Values", "Default", "Description", "starters"));
        sb.append(String.format(fm, Strings.dup((CharSequence)"-", (int)4), Strings.dup((CharSequence)"-", (int)40), Strings.dup((CharSequence)"-", (int)10), Strings.dup((CharSequence)"-", (int)20), Strings.dup((CharSequence)"-", (int)10), Strings.dup((CharSequence)"-", (int)20), Strings.dup((CharSequence)"-", (int)40)));
        int index = 0;
        ArrayList<String> keys = new ArrayList<String>(this.docs.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            PropDocBean doc = this.docs.get(key);
            sb.append(String.format(fm, index, key, doc.need ? "yes" : "no", Strings.join((String)",", (Object[])doc.possible), doc.defaultValue, doc.value, Strings.join((String)",", doc.users)));
            ++index;
        }
        return sb.toString().trim();
    }

    public Map<String, PropDocBean> getDocs() {
        return this.docs;
    }
}

