/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.starter;

import java.util.Arrays;
import java.util.Collection;
import org.nutz.lang.util.NutMap;

public interface MonitorObject {
    public String getMonitorName();

    default public boolean isMonitorEnable() {
        return true;
    }

    default public Collection<String> getMonitorKeys() {
        return Arrays.asList(new String[0]);
    }

    default public Object getMonitorValue(String key) {
        return null;
    }

    default public NutMap getMonitors() {
        NutMap re = new NutMap();
        for (String key : this.getMonitorKeys()) {
            re.put((Object)key, this.getMonitorValue(key));
        }
        return re;
    }

    default public StringBuilder getMonitorForPrint() {
        String LR = "\r\n";
        StringBuilder sb = new StringBuilder();
        sb.append("----------------------------------------------").append(LR);
        for (String key : this.getMonitorKeys()) {
            sb.append(String.format("%-40s : %s", key, this.getMonitorValue(key))).append(LR);
        }
        sb.append("----------------------------------------------");
        return sb;
    }
}

