/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.boot.metrics.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.nutz.boot.metrics.CounterService;

public class MemoryCounterService
implements CounterService {
    protected ConcurrentHashMap<String, AtomicLong> atoms = new ConcurrentHashMap();

    protected AtomicLong getAtomicLong(String metricName) {
        return this.atoms.computeIfAbsent(metricName, name -> new AtomicLong());
    }

    @Override
    public long increment(String metricName) {
        return this.getAtomicLong(metricName).incrementAndGet();
    }

    @Override
    public long decrement(String metricName) {
        return this.getAtomicLong(metricName).decrementAndGet();
    }

    @Override
    public void reset(String metricName) {
        this.atoms.remove(metricName);
    }

    @Override
    public void submit(String metricName, long value) {
        this.getAtomicLong(metricName).set(value);
    }

    @Override
    public long get(String metricName) {
        return this.getAtomicLong(metricName).get();
    }

    @Override
    public Set<String> keys() {
        return new HashSet<String>(this.atoms.keySet());
    }
}

