/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.mvc.websocket.handler;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.websocket.Session;
import org.nutz.Nutz;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.lang.reflect.FastClassFactory;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.mvc.websocket.AbstractWsEndpoint;
import org.nutz.plugins.mvc.websocket.WsHandler;
import org.nutz.plugins.mvc.websocket.WsRoomProvider;

public abstract class AbstractWsHandler
implements WsHandler {
    private static final Log log = Logs.get();
    protected Set<String> rooms;
    protected WsRoomProvider roomProvider;
    protected Session session;
    protected String prefix;
    protected HttpSession httpSession;
    protected AbstractWsEndpoint endpoint;
    protected Map<String, Callback<NutMap>> actions = new HashMap<String, Callback<NutMap>>();

    public AbstractWsHandler(String prefix) {
        this.rooms = new HashSet<String>();
        this.prefix = prefix;
    }

    public void join(String room) {
        if (!Strings.isBlank((CharSequence)room)) {
            this.rooms.add(room);
            room = this.prefix + room;
            log.debugf("session(id=%s) join room(name=%s)", new Object[]{this.session.getId(), room});
            this.roomProvider.join(room, this.session.getId());
        }
    }

    public void left(String room) {
        if (!Strings.isBlank((CharSequence)room)) {
            this.rooms.remove(room);
            room = this.prefix + room;
            log.debugf("session(id=%s) left room(name=%s)", new Object[]{this.session.getId(), room});
            this.roomProvider.left(room, this.session.getId());
        }
    }

    @Override
    public void depose() {
        for (String room : this.rooms) {
            this.left(room);
        }
    }

    @Override
    public void init() {
        for (final Method method : this.getClass().getMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length != 1 || !NutMap.class.isAssignableFrom(paramTypes[0])) continue;
            if (Nutz.majorVersion() == 1 && Nutz.minorVersion() > 60) {
                final FastMethod fm = FastClassFactory.get((Method)method);
                this.actions.put(method.getName(), new Callback<NutMap>(){

                    public void invoke(NutMap msg) {
                        try {
                            fm.invoke((Object)AbstractWsHandler.this, new Object[]{msg});
                        }
                        catch (Throwable e) {
                            AbstractWsHandler.this.onActionError(msg, e);
                        }
                    }
                });
                continue;
            }
            this.actions.put(method.getName(), new Callback<NutMap>(){

                public void invoke(NutMap msg) {
                    try {
                        method.invoke((Object)AbstractWsHandler.this, msg);
                    }
                    catch (Throwable e) {
                        AbstractWsHandler.this.onActionError(msg, e);
                    }
                }
            });
        }
    }

    @Override
    public void onMessage(String message) {
        try {
            NutMap msg = (NutMap)Json.fromJson(NutMap.class, (CharSequence)message);
            String action = msg.getString("action");
            if (Strings.isBlank((CharSequence)action)) {
                return;
            }
            Callback<NutMap> at = this.actions.get(action);
            if (at != null) {
                at.invoke((Object)msg);
            } else {
                this.defaultAction(msg);
            }
        }
        catch (Throwable e) {
            this.onActionError(null, e);
        }
    }

    public void onActionError(NutMap msg, Throwable e) {
        if (log.isInfoEnabled()) {
            log.infof("bad message ? msg=%s", new Object[]{Json.toJson((Object)msg, (JsonFormat)JsonFormat.compact().setIgnoreNull(false)), e});
        }
    }

    public void defaultAction(NutMap msg) {
        if (log.isDebugEnabled()) {
            log.debugf("unknown action msg = %s", new Object[]{Json.toJson((Object)msg, (JsonFormat)JsonFormat.compact().setIgnoreNull(false))});
        }
    }

    @Override
    public void setRoomProvider(WsRoomProvider roomProvider) {
        this.roomProvider = roomProvider;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    @Override
    public void setEndpoint(AbstractWsEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

