/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao.impl.provider;

import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.CacheResult;
import org.nutz.plugins.cache.dao.CachedNutDaoExecutor;
import org.nutz.plugins.cache.dao.impl.provider.AbstractDaoCacheProvider;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisDaoCacheProvider
extends AbstractDaoCacheProvider {
    private static final Log log = Logs.get();
    protected JedisPool jedisPool;

    @Override
    public Object get(String cacheName, String key) {
        byte[] obj = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            obj = jedis.hget(cacheName.getBytes(), key.getBytes());
        }
        if (obj != null) {
            return this.getSerializer().back(obj);
        }
        return CacheResult.NOT_FOUNT;
    }

    @Override
    public boolean put(String cacheName, String key, Object obj) {
        Object data = this.getSerializer().from(obj);
        if (data == null) {
            if (CachedNutDaoExecutor.DEBUG) {
                log.debug((Object)"Serializer.from >> NULL");
            }
            return false;
        }
        if (CachedNutDaoExecutor.DEBUG) {
            log.debugf("CacheName=%s, KEY=%s", new Object[]{cacheName, key});
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.hset(cacheName.getBytes(), key.getBytes(), (byte[])data);
        }
        return true;
    }

    @Override
    public void clear(String cacheName) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.del(cacheName.getBytes());
        }
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void init() throws Throwable {
        super.init();
    }
}

