/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao.impl.provider;

import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.api.DaoCacheProvider;

public class DaoCacheProviderWrapper
implements DaoCacheProvider {
    private static final Log log = Logs.get();
    protected DaoCacheProvider proxy;

    public DaoCacheProviderWrapper(DaoCacheProvider proxy) {
        this.proxy = proxy;
    }

    @Override
    public void init() throws Throwable {
        log.debug((Object)"init ...");
        if (this.proxy != null) {
            this.proxy.init();
        }
    }

    @Override
    public void depose() throws Throwable {
        log.debug((Object)"depose ...");
        if (this.proxy != null) {
            this.proxy.depose();
        }
    }

    @Override
    public Object get(String cacheName, String key) {
        log.debugf("cacheName=%s key=%s", new Object[]{cacheName, key});
        if (this.proxy != null) {
            return this.proxy.get(cacheName, key);
        }
        return null;
    }

    @Override
    public boolean put(String cacheName, String key, Object obj) {
        log.debugf("cacheName=%s key=%s", new Object[]{cacheName, key});
        if (this.proxy != null) {
            return this.proxy.put(cacheName, key, obj);
        }
        return false;
    }

    @Override
    public void clear(String cacheName) {
        log.debugf("cacheName=%s", new Object[]{cacheName});
        if (this.proxy != null) {
            this.proxy.clear(cacheName);
        }
    }
}

