/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.cache.dao.impl.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.cache.dao.CacheResult;
import org.nutz.plugins.cache.dao.impl.convert.AbstractCacheSerializer;

public class JavaCacheSerializer
extends AbstractCacheSerializer {
    private static final Log log = Logs.get();

    @Override
    public Object from(Object obj) {
        if (obj == null) {
            return NULL_OBJ;
        }
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeUnshared(obj);
            oos.close();
            return bao.toByteArray();
        }
        catch (Exception e) {
            log.info((Object)"Object to bytes fail", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object back(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.isNULL_OBJ(obj)) {
            return CacheResult.NULL;
        }
        try {
            ObjectInputStream ins = new ObjectInputStream(new ByteArrayInputStream((byte[])obj));
            Object tmp = ins.readUnshared();
            ins.close();
            return tmp;
        }
        catch (Exception e) {
            log.info((Object)"bytes to Object fail", (Throwable)e);
            return null;
        }
    }
}

