/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.dubbo;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.annotation.Service;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import org.nutz.integration.dubbo.DubboAgent;
import org.nutz.integration.dubbo.ReferenceBean;
import org.nutz.integration.dubbo.ServiceBean;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.resource.Scans;

public class AnnotationBean {
    protected Ioc ioc;
    protected Map<String, IocObject> iobjs;
    protected String beanName;
    private String annotationPackage;
    private String[] annotationPackages;

    public void setPackage(String annotationPackage) {
        this.annotationPackage = annotationPackage;
    }

    public void _init() {
        IocObject iobj;
        String name;
        HashSet<Field> consumers = new HashSet<Field>();
        HashSet<Class> services = new HashSet<Class>();
        for (String pkg : this.annotationPackages == null ? Strings.splitIgnoreBlank((String)this.annotationPackage, (String)",") : this.annotationPackages) {
            for (Class klass : Scans.me().scanPackage(pkg)) {
                if (klass.isInterface()) continue;
                Service service = klass.getAnnotation(Service.class);
                if (service != null) {
                    services.add(klass);
                }
                for (Field field : klass.getDeclaredFields()) {
                    if (!field.getType().isInterface() || field.getAnnotation(Reference.class) == null) continue;
                    consumers.add(field);
                }
            }
        }
        for (Field field : consumers) {
            Reference ref = field.getAnnotation(Reference.class);
            ReferenceBean rc = new ReferenceBean(ref);
            rc.setInterface(field.getType());
            name = R.UU32();
            iobj = Iocs.wrap(rc);
            iobj.setType(ReferenceBean.class);
            DubboAgent.checkIocObject(name, iobj);
            this.iobjs.put(name, iobj);
            iobj = new IocObject();
            iobj.setType(field.getType());
            iobj.setFactory("$" + name + "#get");
            this.iobjs.put(R.UU32(), iobj);
        }
        for (Class klass : services) {
            Service service = klass.getAnnotation(Service.class);
            ServiceBean sc = new ServiceBean(service);
            sc.setRef(this.ioc.getByType(klass));
            name = R.UU32();
            iobj = Iocs.wrap(sc);
            iobj.setType(ServiceBean.class);
            DubboAgent.checkIocObject(name, iobj);
            this.iobjs.put(name, iobj);
        }
    }

    public void depose() {
    }

    public void setPackages(String[] annotationPackages) {
        this.annotationPackages = annotationPackages;
    }
}

