/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.processor;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.HttpAdaptor;
import org.nutz.mvc.HttpAdaptor2;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.adaptor.PairAdaptor;
import org.nutz.mvc.impl.processor.AbstractProcessor;

public class AdaptorProcessor
extends AbstractProcessor {
    private HttpAdaptor adaptor;

    @Override
    public void init(NutConfig config, ActionInfo ai) throws Throwable {
        this.adaptor = AdaptorProcessor.evalHttpAdaptor(config, ai);
    }

    @Override
    public void process(ActionContext ac) throws Throwable {
        List<String> phArgs = ac.getPathArgs();
        HttpServletRequest req = ac.getRequest();
        if (ac.getReferObject() != null) {
            req.setAttribute("nutz.mvc.refer_object", ac.getReferObject());
        }
        Object[] args = this.adaptor.adapt(ac.getServletContext(), req, ac.getResponse(), phArgs.toArray(new String[phArgs.size()]));
        Object referObject = req.getAttribute("nutz.mvc.refer_object");
        ac.setReferObject(referObject);
        req.removeAttribute("nutz.mvc.refer_object");
        ac.setMethodArgs(args);
        this.doNext(ac);
    }

    protected static HttpAdaptor evalHttpAdaptor(NutConfig config, ActionInfo ai) {
        HttpAdaptor re = AdaptorProcessor.evalObj(config, ai.getAdaptorInfo());
        if (null == re) {
            re = new PairAdaptor();
        }
        if (re instanceof HttpAdaptor2) {
            ((HttpAdaptor2)re).init(ai);
        } else {
            re.init(ai.getMethod());
        }
        return re;
    }
}

