/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;

public class CmdParams {
    private static final Pattern PARAM_KEY = Pattern.compile("^-([a-zA-Z_].*)$");
    public String[] vals;
    NutMap map;

    public static CmdParams parse(String[] args, String bools) {
        if (null == bools) {
            return CmdParams.parse(args, null, null);
        }
        if (bools.startsWith("^")) {
            return CmdParams.parse(args, null, bools);
        }
        return CmdParams.parse(args, bools, null);
    }

    public static CmdParams parse(String[] args, String boolChars, String boolRegex) {
        CmdParams params = new CmdParams();
        ArrayList<String> list = new ArrayList<String>(args.length);
        params.map = new NutMap();
        if (args.length > 0) {
            Pattern bool_key = null;
            if (!Strings.isBlank(boolRegex)) {
                bool_key = Pattern.compile(boolRegex);
            }
            Pattern bool_char = null;
            if (!Strings.isBlank(boolChars)) {
                bool_char = Pattern.compile("^-([" + boolChars + "]+)$");
            }
            for (int i = 0; i < args.length; ++i) {
                Matcher m;
                String s = args[i];
                if (null != bool_char && (m = bool_char.matcher(s)).find()) {
                    char[] cs;
                    for (char c : cs = m.group(m.groupCount()).toCharArray()) {
                        params.map.put("" + c, true);
                    }
                    continue;
                }
                m = PARAM_KEY.matcher(s);
                if (m.find()) {
                    String key = m.group(m.groupCount());
                    if (null != bool_key && bool_key.matcher(key).matches()) {
                        params.map.put(key, true);
                        continue;
                    }
                    if (i >= args.length - 1) {
                        params.map.put(key, true);
                        break;
                    }
                    s = args[i + 1];
                    if (s.matches("^-[a-zA-Z_].*$")) {
                        params.map.put(key, true);
                        continue;
                    }
                    params.map.put(key, s);
                    ++i;
                    continue;
                }
                list.add(s);
            }
        }
        params.vals = list.toArray(new String[list.size()]);
        return params;
    }

    protected CmdParams() {
    }

    public String val(int index) {
        int i;
        int n = i = index >= 0 ? index : this.vals.length + index;
        if (i < 0 || i >= this.vals.length) {
            return null;
        }
        return this.vals[i];
    }

    public String val_check(int index) {
        String v = this.val(index);
        if (null == v) {
            throw Er.create("e.cmd.lack.param.vals", index);
        }
        return v;
    }

    public boolean is(String key) {
        return this.map.getBoolean(key, false);
    }

    public boolean is(String key, boolean dft) {
        return this.map.getBoolean(key, dft);
    }

    public void setv(String key, Object val) {
        this.map.setv(key, val);
    }

    public boolean has(String key) {
        return this.map.has(key);
    }

    public boolean hasString(String key) {
        String val = this.get(key);
        return !Strings.isBlank(val) && !"true".equals(val);
    }

    public float getFloat(String key) {
        return this.map.getFloat(key, Float.NaN);
    }

    public float getFloat(String key, float dft) {
        return this.map.getFloat(key, dft);
    }

    public int getInt(String key) {
        return this.map.getInt(key, -1);
    }

    public int getInt(String key, int dft) {
        return this.map.getInt(key, dft);
    }

    public long getLong(String key) {
        return this.map.getLong(key, -1L);
    }

    public long getLong(String key, long dft) {
        return this.map.getLong(key, dft);
    }

    public double getDouble(String key) {
        return this.map.getDouble(key, Double.NaN);
    }

    public double getDouble(String key, double dft) {
        return this.map.getDouble(key, dft);
    }

    public String get(String key) {
        return this.map.getString(key);
    }

    public String get(String key, String dft) {
        return this.map.getString(key, dft);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String dft) {
        Object val = this.map.get(key);
        if (null == val || val instanceof Boolean) {
            return dft;
        }
        return val.toString();
    }

    public String wrap(String key, String fmt) {
        return this.wrap(key, fmt, "");
    }

    public String wrap(String key, String fmt, String dft) {
        String val = this.get(key);
        if (Strings.isBlank(val)) {
            return dft;
        }
        return String.format(fmt, val);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> classOfEnum) {
        return this.map.getEnum(key, classOfEnum);
    }

    public <T> T getAs(String key, Class<T> classOfT) {
        return this.map.getAs(key, classOfT);
    }

    public <T> T getAs(String key, Class<T> classOfT, T dft) {
        return this.map.getAs(key, classOfT, dft);
    }

    public NutMap getMap(String key) {
        return this.getMap(key, null);
    }

    public NutMap getMap(String key, NutMap dft) {
        Object val = this.map.get(key);
        if (null == val) {
            return null;
        }
        if (val instanceof Map) {
            return NutMap.WRAP((Map)val);
        }
        return Lang.map(val.toString());
    }

    public <T> List<T> getList(String key, Class<T> eleType) {
        return this.map.getList(key, eleType);
    }

    public String check(String key) {
        String v = this.get(key);
        if (Strings.isBlank(v)) {
            throw Er.create("e.cmd.lack.param", key);
        }
        return v;
    }

    public int checkInt(String key) {
        String v = this.get(key);
        if (Strings.isBlank(v)) {
            throw Er.create("e.cmd.lack.param.int", key);
        }
        return Integer.valueOf(v);
    }

    public long checkLong(String key) {
        String v = this.get(key);
        if (Strings.isBlank(v)) {
            throw Er.create("e.cmd.lack.param.long", key);
        }
        return Long.valueOf(v);
    }

    public float checkFloat(String key) {
        String v = this.get(key);
        if (Strings.isBlank(v)) {
            throw Er.create("e.cmd.lack.param.float", key);
        }
        return Float.valueOf(v).floatValue();
    }

    public double checkDouble(String key) {
        String v = this.get(key);
        if (Strings.isBlank(v)) {
            throw Er.create("e.cmd.lack.param.double", key);
        }
        return Double.valueOf(key);
    }

    public NutMap map() {
        return this.map;
    }

    static class Er {
        Er() {
        }

        public static RuntimeException create(String msg, Object key) {
            return new RuntimeException(String.format("%s : key=%s", msg, key));
        }
    }
}

