/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.img;

import java.awt.Font;
import org.nutz.lang.OS;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;

public class Fonts {
    private static NutMap fontMap;
    private static final String[] commonFonts;

    public static Font random(int style, int size) {
        Font font = null;
        while (font == null) {
            try {
                int index = R.random(0, commonFonts.length - 1);
                font = Fonts.get(commonFonts[index], style, size);
            }
            catch (Exception exception) {}
        }
        return font;
    }

    public static Font get(String name, int style, int size) {
        if (Strings.isBlank(name)) {
            Font ff = Fonts.find(commonFonts, style, size);
            if (ff == null) {
                throw new RuntimeException("Please manually set the font, or add some common fonts in the system");
            }
            return ff;
        }
        return new Font(name, style, size);
    }

    public static boolean exist(String name) {
        return fontMap.getBoolean(name, false);
    }

    private static Font find(String[] fnames, int style, int size) {
        for (String name : fnames) {
            if (!Fonts.exist(name)) continue;
            return new Font(name, style, size);
        }
        return null;
    }

    static {
        String[] fonts;
        fontMap = NutMap.NEW();
        commonFonts = new String[]{"\u5fae\u8f6f\u96c5\u9ed1", "\u5fae\u8f6f\u6b63\u9ed1\u4f53", "\u9ed1\u4f53", "\u5b8b\u4f53", "\u4eff\u5b8b", "\u65b0\u5b8b\u4f53", "\u6977\u4f53", "\u4eff\u5b8bGB2312", "\u6977\u4f53GB2312", "Microsoft YaHei", "Microsoft YaHei UI", "Microsoft JhengHei", "SimHei", "SimSun", "FangSong", "NSimSun", "FangSongGB2312", "KaiTiGB2312", "\u51ac\u9752\u9ed1\u4f53", "Hiragino Sans GB", "STHeiti", "STSong", "STFangsong", "STKait", "Apple LiGothic Medium", "Apple LiSung Light", "LiHei Pro Medium", "LiSong Pro Light", "Dialog", "Serif", "SansSerif", "Monospaced", "Lucida Sans Typewriter", "DialogInput", "Lucida Bright", "Lucida Sans", "Abyssinica SIL", "AR PL UMing CN", "AR PL UMing HK", "AR PL UMing TW", "AR PL UMing TW MBE", "Bitstream Charter", "Caladea", "Cantarell", "Carlito", "Century Schoolbook L", "Courier 10 Pitch", "Cursor", "DejaVu Sans", "DejaVu Sans Condensed", "DejaVu Sans Light", "DejaVu Sans Mono", "DejaVu Serif", "DejaVu Serif Condensed", "Dialog", "DialogInput", "Dingbats", "FreeMono", "FreeSans", "FreeSerif", "Jomolhari", "Khmer OS", "Khmer OS Content", "Khmer OS System", "Liberation Mono", "Liberation Sans", "Liberation Serif", "LKLUG", "Lohit Assamese", "Lohit Bengali", "Lohit Devanagari", "Lohit Gujarati", "Lohit Kannada", "Lohit Malayalam", "Lohit Marathi", "Lohit Nepali", "Lohit Oriya", "Lohit Punjabi", "Lohit Tamil", "Lohit Telugu", "Lucida Bright", "Lucida Sans", "Lucida Sans Typewriter", "Madan2", "Meera", "Monospaced", "NanumGothic", "NanumGothicExtraBold", "Nimbus Mono L", "Nimbus Roman No9 L", "Nimbus Sans L", "Nuosu SIL", "Open Sans", "Open Sans Extrabold", "Open Sans Light", "Open Sans Semibold", "OpenSymbol", "Overpass", "Padauk", "PakType Naskh Basic", "PT Sans", "PT Sans Narrow", "SansSerif", "Serif", "Standard Symbols L", "STIX", "URW Bookman L", "URW Chancery L", "URW Gothic L", "URW Palladio L", "Utopia", "VL Gothic", "Waree", "WenQuanYi Micro Hei", "WenQuanYi Micro Hei Mono", "WenQuanYi Zen Hei", "WenQuanYi Zen Hei Mono", "WenQuanYi Zen Hei Sharp"};
        for (String fnm : fonts = OS.fontsRefresh()) {
            fontMap.addv(fnm, true);
        }
    }
}

