/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql.run;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.nutz.dao.DaoException;
import org.nutz.dao.DatabaseMeta;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlType;
import org.nutz.dao.sql.VarIndex;
import org.nutz.dao.sql.VarSet;
import org.nutz.dao.util.Daos;
import org.nutz.lang.Configurable;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutDaoExecutor
implements DaoExecutor,
Configurable {
    private static final Log log = Logs.get();
    protected int defaultQueryTimeout;
    protected int defaultFetchSize;
    protected DatabaseMeta meta;
    protected JdbcExpert expert;

    @Override
    public void exec(Connection conn, DaoStatement st) {
        try {
            st.onBefore(conn);
            switch (st.getSqlType()) {
                case SELECT: {
                    this._runSelect(conn, st);
                    break;
                }
                case ALTER: 
                case TRUNCATE: 
                case CREATE: 
                case DROP: {
                    this._runStatement(conn, st);
                    break;
                }
                case RUN: {
                    st.onAfter(conn, null, null);
                    break;
                }
                case CALL: 
                case EXEC: {
                    this._runExec(conn, st);
                    break;
                }
                default: {
                    Object[][] paramMatrix;
                    if (st.isForceExecQuery()) {
                        this._runSelect(conn, st);
                        break;
                    }
                    if (st.getSqlType() == SqlType.OTHER && log.isInfoEnabled()) {
                        log.info("Can't identify SQL type :   " + st);
                    }
                    if (null == (paramMatrix = st.getParamMatrix()) || paramMatrix.length == 0) {
                        this._runStatement(conn, st);
                        break;
                    }
                    this._runPreparedStatement(conn, st, paramMatrix);
                    break;
                }
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("SQLException", e);
                SQLException nextException = e.getNextException();
                if (nextException != null) {
                    log.debug("SQL NextException", nextException);
                }
            }
            throw new DaoException(String.format("!Nutz SQL Error: '%s'\nPreparedStatement: \n'%s'", st.toString(), st.toPreparedStatement()) + "\nCaseMessage=" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _runExec(Connection conn, DaoStatement st) throws SQLException {
        block29: {
            if (st.getContext().getPager() != null) {
                throw Lang.makeThrow(DaoException.class, "NOT Pageable : " + st, new Object[0]);
            }
            String sql = st.toPreparedStatement();
            if (log.isDebugEnabled()) {
                log.debug(sql);
            }
            Object[][] paramMatrix = st.getParamMatrix();
            CallableStatement stmt = null;
            ResultSet rs = null;
            try {
                OutParam outParam;
                int i;
                stmt = conn.prepareCall(sql);
                ValueAdaptor[] adaptors = st.getAdaptors();
                HashMap<Integer, OutParam> outParams = new HashMap<Integer, OutParam>();
                if (st instanceof Sql) {
                    VarIndex varIndex = ((Sql)st).paramIndex();
                    VarSet varSet = ((Sql)st).params();
                    for (i = 0; i < varIndex.size(); ++i) {
                        String name = varIndex.getOrderName(i);
                        if (!name.startsWith("OUT") || varSet.get(name).getClass() != Integer.class) continue;
                        Integer t = (Integer)varSet.get(name);
                        outParams.put(i, new OutParam(name, t));
                    }
                }
                if (paramMatrix != null && paramMatrix.length > 0) {
                    CallableStatement pst = stmt;
                    Object[] pm = paramMatrix[0];
                    for (i = 0; i < pm.length; ++i) {
                        outParam = (OutParam)outParams.get(i);
                        if (outParam == null) {
                            adaptors[i].set(pst, pm[i], i + 1);
                            continue;
                        }
                        stmt.registerOutParameter(i + 1, outParam.jdbcType);
                    }
                }
                stmt.execute();
                if (outParams.size() > 0) {
                    Record r = Record.create();
                    for (Map.Entry en : outParams.entrySet()) {
                        Object value;
                        outParam = (OutParam)en.getValue();
                        int jdbcIndex = (Integer)en.getKey() + 1;
                        switch (outParam.jdbcType) {
                            case 4: {
                                value = stmt.getInt(jdbcIndex);
                                break;
                            }
                            case 93: {
                                value = stmt.getTimestamp(jdbcIndex);
                                break;
                            }
                            case 2005: {
                                value = stmt.getString(jdbcIndex);
                                break;
                            }
                            case 91: {
                                value = stmt.getDate(jdbcIndex);
                                break;
                            }
                            default: {
                                value = stmt.getObject(jdbcIndex);
                            }
                        }
                        r.set(outParam.name.substring(3), value);
                    }
                    st.getContext().attr("OUT", r);
                }
                rs = stmt.getResultSet();
                try {
                    st.onAfter(conn, rs, null);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                if (!stmt.getMoreResults()) break block29;
                rs = stmt.getResultSet();
                try {
                    if (rs != null) {
                        st.onAfter(conn, rs, null);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runSelect(Connection conn, DaoStatement st) throws SQLException {
        Pager pager;
        Object[][] paramMatrix = st.getParamMatrix();
        int startRow = -1;
        int lastRow = -1;
        if (st.getContext().getResultSetType() == 1004 && (pager = st.getContext().getPager()) != null) {
            startRow = pager.getOffset();
            lastRow = pager.getOffset() + pager.getPageSize();
        }
        String sql = st.toPreparedStatement();
        ResultSet rs = null;
        Statement stat = null;
        try {
            if (null == paramMatrix || paramMatrix.length == 0 || paramMatrix[0].length == 0) {
                stat = conn.createStatement(st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                this.afterCreateStatement(stat, st);
                rs = stat.executeQuery(sql);
            } else {
                if (paramMatrix.length > 1 && log.isWarnEnabled()) {
                    log.warnf("Drop last %d rows parameters for:\n%s", paramMatrix.length - 1, st);
                }
                ValueAdaptor[] adaptors = st.getAdaptors();
                stat = conn.prepareStatement(sql, st.getContext().getResultSetType(), 1007);
                if (lastRow > 0) {
                    stat.setMaxRows(lastRow);
                }
                this.afterCreateStatement(stat, st);
                for (int i = 0; i < paramMatrix[0].length; ++i) {
                    adaptors[i].set((PreparedStatement)stat, paramMatrix[0][i], i + 1);
                }
                rs = ((PreparedStatement)stat).executeQuery();
            }
            if (startRow > 0) {
                rs.absolute(startRow);
            }
            st.onAfter(conn, rs, stat);
        }
        catch (Throwable throwable) {
            Daos.safeClose(stat, rs);
            throw throwable;
        }
        Daos.safeClose(stat, rs);
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _runPreparedStatement(Connection conn, DaoStatement st, Object[][] paramMatrix) throws SQLException {
        block12: {
            ValueAdaptor[] adaptors = st.getAdaptors();
            if (adaptors.length != paramMatrix[0].length) {
                throw Lang.makeThrow("DaoStatement adaptor MUST same width with param matrix.", new Object[0]);
            }
            boolean statIsClosed = false;
            String sql = st.toPreparedStatement();
            PreparedStatement pstat = null;
            try {
                pstat = st.getContext().attr("RETURN_GENERATED_KEYS") == null ? conn.prepareStatement(sql) : conn.prepareStatement(sql, 1);
                if (paramMatrix.length == 1) {
                    for (int i = 0; i < paramMatrix[0].length; ++i) {
                        adaptors[i].set(pstat, paramMatrix[0][i], i + 1);
                    }
                    pstat.execute();
                    st.getContext().setUpdateCount(pstat.getUpdateCount());
                    st.onAfter(conn, null, pstat);
                    pstat.close();
                    statIsClosed = true;
                } else {
                    for (Object[] params : paramMatrix) {
                        for (int i = 0; i < params.length; ++i) {
                            adaptors[i].set(pstat, params[i], i + 1);
                        }
                        pstat.addBatch();
                    }
                    int[] counts = pstat.executeBatch();
                    int sum = 0;
                    for (int i : counts) {
                        if (i <= 0) continue;
                        sum += i;
                    }
                    if (sum == 0) {
                        sum = pstat.getUpdateCount();
                    }
                    st.onAfter(conn, null, pstat);
                    pstat.close();
                    statIsClosed = true;
                    st.getContext().setUpdateCount(sum);
                }
                if (statIsClosed) break block12;
            }
            catch (Throwable throwable) {
                if (!statIsClosed) {
                    Daos.safeClose(pstat);
                }
                throw throwable;
            }
            Daos.safeClose(pstat);
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runStatement(Connection conn, DaoStatement st) throws SQLException {
        boolean statIsClosed = false;
        Statement stat = null;
        String sql = st.toPreparedStatement();
        try {
            stat = conn.createStatement();
            stat.execute(sql);
            st.getContext().setUpdateCount(stat.getUpdateCount());
            st.onAfter(conn, null, stat);
            stat.close();
            statIsClosed = true;
        }
        finally {
            if (!statIsClosed) {
                Daos.safeClose(stat);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("...DONE");
        }
    }

    public void setMeta(DatabaseMeta meta) {
        this.meta = meta;
    }

    public void setExpert(JdbcExpert expert) {
        this.expert = expert;
    }

    public static void printSQL(DaoStatement sql) {
        if (log.isDebugEnabled()) {
            log.debug(sql.forPrint());
        }
    }

    protected void afterCreateStatement(Statement stat, DaoStatement st) throws SQLException {
        if (st.getContext().getFetchSize() != 0) {
            stat.setFetchSize(st.getContext().getFetchSize());
        } else if (this.defaultFetchSize > 0) {
            stat.setFetchSize(this.defaultFetchSize);
        }
        if (st.getContext().getQueryTimeout() > 0) {
            stat.setQueryTimeout(st.getContext().getQueryTimeout());
        } else if (this.defaultQueryTimeout > 0) {
            stat.setQueryTimeout(this.defaultQueryTimeout);
        }
    }

    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public void setDefaultFetchSize(int defaultFetchSize) {
        this.defaultFetchSize = defaultFetchSize;
    }

    @Override
    public void setupProperties(NutMap conf) {
        this.defaultQueryTimeout = conf.getInt("nutz.dao.query.timeout", 0);
        this.defaultFetchSize = conf.getInt("nutz.dao.query.fetchSize", 0);
    }

    static class OutParam
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String name;
        int jdbcType;

        public OutParam() {
        }

        public OutParam(String name, int jdbcType) {
            this.name = name;
            this.jdbcType = jdbcType;
        }
    }
}

