/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.castor.Castors;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.MethodParamNamesScaner;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.HttpAdaptor2;
import org.nutz.mvc.Scope;
import org.nutz.mvc.ViewModel;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.adaptor.injector.AllAttrInjector;
import org.nutz.mvc.adaptor.injector.AppAttrInjector;
import org.nutz.mvc.adaptor.injector.ArrayInjector;
import org.nutz.mvc.adaptor.injector.CookieInjector;
import org.nutz.mvc.adaptor.injector.HttpInputStreamInjector;
import org.nutz.mvc.adaptor.injector.HttpReaderInjector;
import org.nutz.mvc.adaptor.injector.IocInjector;
import org.nutz.mvc.adaptor.injector.IocObjInjector;
import org.nutz.mvc.adaptor.injector.NameInjector;
import org.nutz.mvc.adaptor.injector.PathArgInjector;
import org.nutz.mvc.adaptor.injector.ReqHeaderInjector;
import org.nutz.mvc.adaptor.injector.RequestAttrInjector;
import org.nutz.mvc.adaptor.injector.RequestInjector;
import org.nutz.mvc.adaptor.injector.ResponseInjector;
import org.nutz.mvc.adaptor.injector.ServletContextInjector;
import org.nutz.mvc.adaptor.injector.SessionAttrInjector;
import org.nutz.mvc.adaptor.injector.SessionInjector;
import org.nutz.mvc.adaptor.injector.ViewModelInjector;
import org.nutz.mvc.annotation.Attr;
import org.nutz.mvc.annotation.Cookie;
import org.nutz.mvc.annotation.IocObj;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.annotation.ReqHeader;
import org.nutz.mvc.impl.AdaptorErrorContext;

public abstract class AbstractAdaptor
implements HttpAdaptor2 {
    private static final Log log = Logs.get();
    protected ParamInjector[] injs;
    protected Method method;
    protected Class<?>[] argTypes;
    protected String[] defaultValues;
    protected String[] paramNames;
    protected int curIndex;
    protected int errCtxIndex;

    @Override
    public void init(ActionInfo ai) {
        this.init(ai.getMethod(), ai.getParamNames());
    }

    @Override
    public void init(Method method) {
        this.init(method, Lang.collection2array(MethodParamNamesScaner.getParamNames(method), String.class));
    }

    protected void init(Method method, String[] paramNames) {
        this.method = method;
        this.paramNames = paramNames;
        this.argTypes = method.getParameterTypes();
        this.injs = new ParamInjector[this.argTypes.length];
        this.defaultValues = new String[this.argTypes.length];
        this.errCtxIndex = -1;
        Annotation[][] annss = method.getParameterAnnotations();
        Type[] types = method.getGenericParameterTypes();
        for (int i = 0; i < annss.length; ++i) {
            String tmp;
            this.curIndex = i;
            if (AdaptorErrorContext.class.isAssignableFrom(this.argTypes[i])) {
                if (this.errCtxIndex != -1) continue;
                this.errCtxIndex = i;
                continue;
            }
            Annotation[] anns = annss[i];
            Param param = null;
            Attr attr = null;
            IocObj iocObj = null;
            ReqHeader reqHeader = null;
            Cookie cookie = null;
            for (int x = 0; x < anns.length; ++x) {
                if (anns[x] instanceof Param) {
                    param = (Param)anns[x];
                    break;
                }
                if (anns[x] instanceof Attr) {
                    attr = (Attr)anns[x];
                    break;
                }
                if (anns[x] instanceof IocObj) {
                    iocObj = (IocObj)anns[x];
                    break;
                }
                if (anns[x] instanceof ReqHeader) {
                    reqHeader = (ReqHeader)anns[x];
                    break;
                }
                if (!(anns[x] instanceof Cookie)) continue;
                cookie = (Cookie)anns[x];
            }
            if (null != attr) {
                this.injs[i] = AbstractAdaptor.evalInjectorByAttrScope(attr);
                continue;
            }
            if (null != iocObj) {
                this.injs[i] = new IocObjInjector(method.getParameterTypes()[i], iocObj.value());
                continue;
            }
            if (null != reqHeader) {
                this.injs[i] = new ReqHeaderInjector(reqHeader.value(), this.argTypes[i]);
                continue;
            }
            if (null != cookie) {
                this.injs[i] = new CookieInjector(cookie.value(), this.argTypes[i]);
                continue;
            }
            this.injs[i] = AbstractAdaptor.evalInjectorByParamType(this.argTypes[i]);
            if (null != this.injs[i]) continue;
            this.injs[i] = this.evalInjector(types[i], param);
            if (null == this.injs[i]) {
                this.injs[i] = this.paramNameInject(method, i);
            }
            if (param == null || (tmp = param.df()) == null || tmp.equals("//NOT EXIST IN//")) continue;
            this.defaultValues[i] = tmp;
        }
    }

    private static ParamInjector evalInjectorByAttrScope(Attr attr) {
        if (attr.scope() == Scope.APP) {
            return new AppAttrInjector(attr.value());
        }
        if (attr.scope() == Scope.SESSION) {
            return new SessionAttrInjector(attr.value());
        }
        if (attr.scope() == Scope.REQUEST) {
            return new RequestAttrInjector(attr.value());
        }
        return new AllAttrInjector(attr.value());
    }

    private static ParamInjector evalInjectorByParamType(Class<?> type) {
        if (ServletRequest.class.isAssignableFrom(type)) {
            return new RequestInjector();
        }
        if (ServletResponse.class.isAssignableFrom(type)) {
            return new ResponseInjector();
        }
        if (HttpSession.class.isAssignableFrom(type)) {
            return new SessionInjector();
        }
        if (ServletContext.class.isAssignableFrom(type)) {
            return new ServletContextInjector();
        }
        if (Ioc.class.isAssignableFrom(type)) {
            return new IocInjector();
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return new HttpInputStreamInjector();
        }
        if (Reader.class.isAssignableFrom(type)) {
            return new HttpReaderInjector();
        }
        if (ViewModel.class.isAssignableFrom(type)) {
            return new ViewModelInjector();
        }
        return null;
    }

    protected ParamInjector evalInjector(Type type, Param param) {
        return this.evalInjectorBy(type, param);
    }

    protected abstract ParamInjector evalInjectorBy(Type var1, Param var2);

    @Override
    public Object[] adapt(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        Object obj;
        Object[] args = new Object[this.argTypes.length];
        if (args.length != this.injs.length) {
            throw new IllegalArgumentException("args.length != injs.length , You get a bug, pls report it!!");
        }
        AdaptorErrorContext errCtx = null;
        if (this.errCtxIndex > -1) {
            errCtx = (AdaptorErrorContext)((Object)Mirror.me(this.argTypes[this.errCtxIndex]).born(this.argTypes.length));
        }
        try {
            obj = this.getReferObject(sc, req, resp, pathArgs);
        }
        catch (Throwable e) {
            if (errCtx != null) {
                if (log.isInfoEnabled()) {
                    log.info("Adapter Error catched , but I found AdaptorErrorContext param, so, set it to args, and continue", e);
                }
                errCtx.setAdaptorError(e, this);
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i] != null) continue;
                    if (this.defaultValues[i] != null) {
                        args[i] = Castors.me().castTo(this.defaultValues[i], this.argTypes[i]);
                        continue;
                    }
                    if (!this.argTypes[i].isPrimitive()) continue;
                    args[i] = Lang.getPrimitiveDefaultValue(this.argTypes[i]);
                }
                args[args.length - 1] = errCtx;
                return args;
            }
            throw Lang.wrapThrow(e);
        }
        int curPathArgIdx = 0;
        int len = null == pathArgs ? 0 : pathArgs.length;
        for (int i = 0; i < args.length; ++i) {
            if (AdaptorErrorContext.class.isAssignableFrom(this.argTypes[i])) continue;
            Object value = null;
            if (curPathArgIdx < len) {
                value = pathArgs[curPathArgIdx];
                ++curPathArgIdx;
            } else {
                value = obj;
            }
            try {
                args[i] = this.injs[i].get(sc, req, resp, value);
            }
            catch (Throwable e) {
                if (errCtx != null) {
                    log.infof("Adapter Param Error(%s) index=%d", this.method, i, e);
                    errCtx.setError(i, e, this.method, value, this.injs[i]);
                }
                throw Lang.wrapThrow(e);
            }
            if (args[i] != null) continue;
            if (this.defaultValues[i] != null) {
                args[i] = Castors.me().castTo(this.defaultValues[i], this.argTypes[i]);
                continue;
            }
            if (!this.argTypes[i].isPrimitive()) continue;
            args[i] = Lang.getPrimitiveDefaultValue(this.argTypes[i]);
        }
        if (errCtx == null) {
            return args;
        }
        for (Throwable err : errCtx.getErrors()) {
            if (err == null) continue;
            if (this.errCtxIndex > -1) {
                if (log.isInfoEnabled()) {
                    log.info("Adapter Param Error catched , but I found AdaptorErrorContext param, so, set it to args, and continue");
                }
                args[this.errCtxIndex] = errCtx;
                return args;
            }
            throw Lang.wrapThrow(err);
        }
        return args;
    }

    protected Object getReferObject(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        return null;
    }

    protected ParamInjector paramNameInject(Method method, int index) {
        if (!Lang.isAndroid) {
            String paramName = this.getParamRealName(index);
            if (paramName != null) {
                Class<?> type = this.argTypes[index];
                if (type.isArray()) {
                    return new ArrayInjector(paramName, null, type, null, null, true);
                }
                return new NameInjector(paramName, null, this.argTypes[index], null, null);
            }
            if (log.isInfoEnabled()) {
                log.infof("Complie without debug info? can't deduce param name. fail back to PathArgInjector!! index=%d > %s", index, method);
            }
        }
        return new PathArgInjector(method.getParameterTypes()[index]);
    }

    protected String getParamRealName(int index) {
        if (this.paramNames == null || this.paramNames.length <= index) {
            return "arg" + index;
        }
        return this.paramNames[index];
    }
}

