/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Xmls;
import org.nutz.lang.meta.Pair;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.HtmlToken;
import org.nutz.lang.util.Node;
import org.nutz.lang.util.SimpleNode;

public class Tag
extends SimpleNode<HtmlToken> {
    private String htmlSegment;

    public static Tag tag(String name, String ... attrs) {
        return Tag.NEW(name).attrs(attrs);
    }

    public static Tag NEW(String name) {
        Tag tag = new Tag();
        tag.set(new HtmlToken().setName(name));
        return tag;
    }

    public static Tag text(String text) {
        Tag tag = new Tag();
        if (null != text) {
            text = Strings.escapeHtml(text);
        }
        tag.set(new HtmlToken().setValue(text));
        return tag;
    }

    public static Tag html(String html) {
        Tag tag = new Tag();
        tag.htmlSegment = html;
        return tag;
    }

    public boolean isBlock() {
        return this.is("^(HEAD|DIV|P|UL|OL|LI|BLOCKQUOTE|PRE|TITLE|H[1-9]|HR|TABLE|TR|TD)$");
    }

    public boolean isInline() {
        return this.is("^(SPAN|B|I|U|EM|DEL|STRONG|SUB|SUP|CODE|FONT)$");
    }

    public boolean isNoChild() {
        return this.is("^(BR|HR|IMG|LINK|META)$");
    }

    public boolean isHeading() {
        return this.is("^H[1-9]$");
    }

    public int getHeadingLevel() {
        Matcher m;
        if (this.isElement() && (m = Pattern.compile("^H([1-9])$").matcher(this.tagName())).find()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public boolean isList() {
        return this.is("^[OU]L$");
    }

    public boolean is(String regex) {
        String tagName = this.tagName();
        if (null == tagName) {
            return false;
        }
        if (regex.startsWith("^")) {
            return tagName.matches(regex.toUpperCase());
        }
        return tagName.equals(regex.toUpperCase());
    }

    public boolean isHtml() {
        return this.is("HTML");
    }

    public boolean isBody() {
        return this.is("BODY");
    }

    public boolean isElement() {
        if (null != this.htmlSegment) {
            return true;
        }
        return ((HtmlToken)this.get()).isElement();
    }

    public boolean isTextNode() {
        if (null != this.htmlSegment) {
            return false;
        }
        return ((HtmlToken)this.get()).isText();
    }

    public boolean isChildAllInline() {
        if (!((HtmlToken)this.get()).isElement()) {
            return false;
        }
        for (Node ht : this.getChildren()) {
            if (!((Tag)ht).isBlock()) continue;
            return false;
        }
        return true;
    }

    public List<Tag> getChildTags() {
        List list = this.getChildren();
        ArrayList<Tag> tags = new ArrayList<Tag>(list.size());
        for (Node ele : list) {
            tags.add((Tag)ele);
        }
        return tags;
    }

    public String name() {
        return ((HtmlToken)this.get()).getName();
    }

    public String tagName() {
        if (null != this.htmlSegment) {
            int pos;
            if (this.htmlSegment.startsWith("<") && (pos = this.htmlSegment.indexOf(32)) > 1) {
                return this.htmlSegment.substring(1, pos);
            }
            return null;
        }
        return ((HtmlToken)this.get()).getTagName();
    }

    public Tag attr(String name, String value) {
        ((HtmlToken)this.get()).attr(name, value);
        return this;
    }

    public Tag attr(String name, int value) {
        return this.attr(name, String.valueOf(value));
    }

    public String attr(String name) {
        return ((HtmlToken)this.get()).getAttrVal(name);
    }

    public Tag attrs(String ... attrs) {
        if (null != attrs) {
            block4: for (String attr : attrs) {
                if (null == attr || attr.length() <= 1) continue;
                char c = attr.charAt(0);
                switch (c) {
                    case '.': {
                        this.addClass(attr.substring(1));
                        continue block4;
                    }
                    case '#': {
                        this.id(attr.substring(1));
                        continue block4;
                    }
                    default: {
                        Pair<String> p = Pair.create(attr);
                        this.attr(p.getName(), p.getValue());
                    }
                }
            }
        }
        return this;
    }

    public Tag addClass(String name) {
        String cns = ((HtmlToken)this.get()).getAttrVal("class");
        String[] nms = Strings.splitIgnoreBlank(cns, " ");
        if (null == nms) {
            ((HtmlToken)this.get()).attr("class", name);
        } else if (!Lang.contains(nms, name)) {
            ((HtmlToken)this.get()).attr("class", cns + " " + name);
        }
        return this;
    }

    public boolean hasClass(String name) {
        String cns = ((HtmlToken)this.get()).getAttrVal("class");
        if (null == cns || cns.length() < name.length()) {
            return false;
        }
        return (" " + cns + " ").indexOf(" " + name + " ") != -1;
    }

    public Tag add(String tagName, String ... attrs) {
        Tag re = Tag.tag(tagName, attrs);
        this.add(re);
        return re;
    }

    public Tag id(String id) {
        ((HtmlToken)this.get()).attr("id", id);
        return this;
    }

    public String id() {
        return ((HtmlToken)this.get()).getAttrVal("id");
    }

    public String getNodeValue() {
        return ((HtmlToken)this.get()).getValue();
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (Node nd : this.getChildren()) {
            Tag tag = (Tag)nd;
            if (tag.isTextNode()) {
                sb.append(((HtmlToken)nd.get()).getValue());
                continue;
            }
            if (tag.isNoChild()) {
                sb.append(' ');
                continue;
            }
            sb.append(tag.getText());
        }
        return sb.toString();
    }

    public Tag setText(String text) {
        this.add(Tag.text(text));
        return this;
    }

    public List<Tag> childrenTag() {
        List children = this.getChildren();
        ArrayList<Tag> list = new ArrayList<Tag>(children.size());
        for (Node nd : children) {
            list.add((Tag)nd);
        }
        return list;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder();
        Tag.__join_to_string(sb, this, level, true, null);
        return sb.toString();
    }

    public String toOuterHtml(boolean autoIndent) {
        return this.toOuterHtml(autoIndent, null);
    }

    public String toOuterHtml(boolean autoIndent, Callback<Tag> tagWatcher) {
        int level = autoIndent ? 0 : -1;
        StringBuilder sb = new StringBuilder();
        Tag.__join_to_string(sb, this, level, false, tagWatcher);
        return sb.toString();
    }

    public String toInnerHtml(boolean autoIndent) {
        return this.toInnerHtml(autoIndent, null);
    }

    public String toInnerHtml(boolean autoIndent, Callback<Tag> tagWatcher) {
        int level = autoIndent ? 0 : -1;
        StringBuilder sb = new StringBuilder();
        for (Node child : this.getChildren()) {
            Tag childTag = (Tag)child;
            Tag.__join_to_string(sb, childTag, level, false, tagWatcher);
            if (!childTag.isBlock() && !childTag.isBody()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void __join_to_string(StringBuilder sb, Tag tag, int level, boolean closeNoChild, Callback<Tag> tagWatcher) {
        String prefix;
        if (null != tagWatcher) {
            tagWatcher.invoke(tag);
        }
        if (null != tag.htmlSegment) {
            sb.append(tag.htmlSegment);
            return;
        }
        if (((HtmlToken)tag.get()).isText()) {
            sb.append(((HtmlToken)tag.get()).getValue());
            return;
        }
        String string = prefix = level >= 0 ? Strings.dup(' ', level * 4) : null;
        if (tag.isNoChild()) {
            Tag.__join_tag_prefix(sb, tag, prefix);
            sb.append('<').append(tag.name());
            Tag.__join_attributes(sb, tag);
            if (closeNoChild) {
                sb.append('/');
            }
            sb.append('>');
        } else if (tag.isInline()) {
            Tag.__join_tag_prefix(sb, tag, prefix);
            Tag.__join_tag_begin(sb, tag);
            for (Node child : tag.getChildren()) {
                Tag.__join_to_string(sb, (Tag)child, level, closeNoChild, tagWatcher);
            }
            Tag.__join_tag_end(sb, tag);
        } else {
            Tag.__join_tag_prefix(sb, tag, prefix);
            Tag.__join_tag_begin(sb, tag);
            for (Node child : tag.getChildren()) {
                Tag childTag = (Tag)child;
                if (childTag.isBlock() || childTag.isBody()) {
                    sb.append('\n');
                }
                Tag.__join_to_string(sb, childTag, level >= 0 ? level + 1 : level, closeNoChild, tagWatcher);
            }
            sb.append('\n');
            Tag.__join_tag_prefix(sb, tag, prefix);
            Tag.__join_tag_end(sb, tag);
        }
    }

    private static void __join_tag_prefix(StringBuilder sb, Tag tag, String prefix) {
        if (null != prefix && prefix.length() > 0) {
            sb.append(prefix);
        }
    }

    private static void __join_tag_begin(StringBuilder sb, Tag tag) {
        sb.append('<').append(tag.name());
        Tag.__join_attributes(sb, tag);
        sb.append('>');
    }

    private static void __join_tag_end(StringBuilder sb, Tag tag) {
        sb.append("</").append(tag.name()).append('>');
    }

    private static void __join_attributes(StringBuilder sb, Tag tag) {
        for (Pair<String> attr : ((HtmlToken)tag.get()).getAttributes()) {
            sb.append(' ').append(attr.toString());
        }
    }

    @Override
    public void toXml(StringBuilder sb, int level) {
        if (level == 0) {
            sb.append(Xmls.HEAD);
        }
        if (sb.length() > 2 && sb.charAt(sb.length() - 1) != '\n') {
            sb.append("\r\n");
        }
        if (level > 0) {
            sb.append(Strings.dup(' ', level * 2));
        }
        Tag.__join_tag_begin(sb, this);
        if (this.getChildren().size() == 1) {
            sb.append(this.getText());
        } else if (this.hasChild()) {
            for (Node node : this.getChildren()) {
                node.toXml(sb, level + 1);
            }
            if (level > 0) {
                sb.append(Strings.dup(' ', level * 2));
            }
        }
        Tag.__join_tag_end(sb, this);
        sb.append("\r\n");
    }
}

