/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.eject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nutz.conf.NutConf;
import org.nutz.lang.FailToGetValueException;
import org.nutz.lang.Lang;
import org.nutz.lang.eject.Ejecting;
import org.nutz.lang.reflect.FastClassFactory;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class EjectByGetter
implements Ejecting {
    private static final Log log = Logs.get();
    private Method getter;
    protected FastMethod fm;

    public EjectByGetter(Method getter) {
        this.getter = getter;
    }

    @Override
    public Object eject(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (NutConf.USE_FASTCLASS) {
                if (this.fm == null) {
                    this.fm = FastClassFactory.get(this.getter);
                }
                if (this.fm == null) {
                    return this.getter.invoke(obj, new Object[0]);
                }
                return this.fm.invoke(obj, new Object[0]);
            }
            return this.getter.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new FailToGetValueException("getter=" + this.getter, e);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Fail to value by getter", e);
            }
            throw Lang.makeThrow("Fail to invoke getter %s.'%s()' %s because [%s]: %s", this.getter.getDeclaringClass().getName(), this.getter.getName(), obj == null || this.getClass().getDeclaringClass() == obj.getClass() ? "" : "<" + obj.getClass() + ">", Lang.unwrapThrow(e), Lang.unwrapThrow(e).getMessage());
        }
    }
}

