/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.img;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;

public final class Colors {
    @Deprecated
    public static Color fromString(String str) {
        return Colors.as(str);
    }

    public static Color as(String str) {
        Pattern p;
        Matcher m;
        if (null == str) {
            return Color.BLACK;
        }
        if ((str = Strings.trim(str.toUpperCase())).startsWith("#")) {
            str = str.substring(1);
        }
        if (str.endsWith(";")) {
            str = str.substring(0, str.length() - 1);
        }
        if ((m = (p = Pattern.compile("^([0-9A-F])([0-9A-F])([0-9A-F])$")).matcher(str)).find()) {
            return new Color(Integer.parseInt(Strings.dup(m.group(1), 2), 16), Integer.parseInt(Strings.dup(m.group(2), 2), 16), Integer.parseInt(Strings.dup(m.group(3), 2), 16));
        }
        p = Pattern.compile("^([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
        }
        p = Pattern.compile("^([0-9A-F])([0-9A-F])([0-9A-F])([0-9A-F])$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(Strings.dup(m.group(2), 2), 16), Integer.parseInt(Strings.dup(m.group(3), 2), 16), Integer.parseInt(Strings.dup(m.group(4), 2), 16), Integer.parseInt(Strings.dup(m.group(1), 2), 16));
        }
        p = Pattern.compile("^([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
        }
        p = Pattern.compile("^RGB\\s*[(]\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*[)]$");
        m = p.matcher(str);
        if (m.find()) {
            return new Color(Integer.parseInt(m.group(1), 10), Integer.parseInt(m.group(2), 10), Integer.parseInt(m.group(3), 10));
        }
        p = Pattern.compile("^RGBA\\s*[(]\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*((\\d[.])?\\d+)\\s*[)]$");
        m = p.matcher(str);
        if (m.find()) {
            float alpha = Float.parseFloat(m.group(4));
            return new Color(Integer.parseInt(m.group(1), 10), Integer.parseInt(m.group(2), 10), Integer.parseInt(m.group(3), 10), (int)(255.0f * alpha));
        }
        return Color.BLACK;
    }

    public static String toRGB(Color color) {
        return String.format("rgb(%d, %d, %d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color randomColor(int min, int max) {
        if (min > 255) {
            min = 255;
        }
        if (min < 0) {
            min = 0;
        }
        if (max > 255) {
            max = 255;
        }
        if (max < 0) {
            max = 0;
        }
        return new Color(min + R.random(0, max - min), min + R.random(0, max - min), min + R.random(0, max - min));
    }

    public static Color randomColor() {
        return Colors.randomColor(0, 255);
    }

    public static int[] getRGB(BufferedImage srcIm, int x, int y) {
        int pixel = srcIm.getRGB(x, y);
        return Colors.getRGB(pixel);
    }

    public static int[] getRGB(int pixel) {
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        return new int[]{r, g, b};
    }

    public static int getAlpha(int pixel) {
        ColorModel cm = ColorModel.getRGBdefault();
        return cm.getAlpha(pixel);
    }

    public static int getLuminance(BufferedImage srcIm, int x, int y) {
        int[] rgb = Colors.getRGB(srcIm, x, y);
        return (int)(0.3 * (double)rgb[0] + 0.59 * (double)rgb[1] + 0.11 * (double)rgb[2]);
    }

    public static double getLuminanceDouble(BufferedImage srcIm, int x, int y) {
        int[] rgb = Colors.getRGB(srcIm, x, y);
        return 0.3 * (double)rgb[0] + 0.59 * (double)rgb[1] + 0.11 * (double)rgb[2];
    }

    public static int getGray(BufferedImage srcIm, int x, int y) {
        int grayValue = Colors.getLuminance(srcIm, x, y);
        int newPixel = 0;
        newPixel = grayValue << 16 & 0xFF0000 | newPixel & 0xFF00FFFF;
        newPixel = grayValue << 8 & 0xFF00 | newPixel & 0xFFFF00FF;
        newPixel = grayValue & 0xFF | newPixel & 0xFFFFFF00;
        return newPixel;
    }

    public static int getMultiply(int pixel1, int pixel2) {
        int[] rgb1 = Colors.getRGB(pixel1);
        int[] rgb2 = Colors.getRGB(pixel2);
        int r = rgb1[0] * rgb2[0] / 255;
        int g = rgb1[1] * rgb2[1] / 255;
        int b = rgb1[2] * rgb2[2] / 255;
        return new Color(r, g, b).getRGB();
    }

    private Colors() {
    }
}

