/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nutz.dao.Condition;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.sql.NutStatement;
import org.nutz.dao.impl.sql.SimpleVarSet;
import org.nutz.dao.impl.sql.SqlLiteral;
import org.nutz.dao.impl.sql.pojo.AbstractPItem;
import org.nutz.dao.impl.sql.pojo.StaticPItem;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.PItem;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.sql.VarIndex;
import org.nutz.dao.sql.VarSet;
import org.nutz.dao.util.Pojos;
import org.nutz.lang.Each;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class NutSql
extends NutStatement
implements Sql {
    private static final long serialVersionUID = 1L;
    protected String sourceSql;
    protected VarSet vars;
    protected List<VarSet> rows;
    protected VarSet params;
    protected SqlCallback callback;
    protected VarIndex varIndex;
    protected VarIndex paramIndex;
    protected Map<String, ValueAdaptor> customValueAdaptor;
    protected List<PItem> items;
    protected char[] placeholder;

    public NutSql(String source) {
        this(source, null);
    }

    public NutSql(String source, SqlCallback callback) {
        this.setSourceSql(source);
        this.callback = callback;
        this.vars = new SimpleVarSet();
        this.rows = new ArrayList<VarSet>();
        this.params = new SimpleVarSet();
        this.rows.add(this.params);
        this.customValueAdaptor = new HashMap<String, ValueAdaptor>();
    }

    @Override
    public void setSourceSql(String sql) {
        int[] is;
        this.sourceSql = sql;
        SqlLiteral literal = this.literal();
        this.varIndex = literal.getVarIndexes();
        this.paramIndex = literal.getParamIndexes();
        if (this.getSqlType() == null) {
            this.setSqlType(literal.getType());
        }
        String[] ss = literal.stack.cloneChain();
        PItem[] tmp = new PItem[ss.length];
        for (String var : this.varIndex.getOrders()) {
            is = this.varIndex.indexesOf(var);
            if (is == null) continue;
            for (int i : is) {
                tmp[i] = new SqlVarPItem(var);
            }
        }
        for (String param : this.paramIndex.getOrders()) {
            is = this.paramIndex.indexesOf(param);
            if (is == null) continue;
            for (int i : is) {
                tmp[i] = new SqlParamPItem(param);
            }
        }
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] != null) continue;
            tmp[i] = new StaticPItem(ss[i], true);
        }
        this.items = Arrays.asList(tmp);
    }

    protected int _params_count() {
        int count = 0;
        Entity<?> en = this.getEntity();
        for (PItem item : this.items) {
            count += item.paramCount(en);
        }
        return count;
    }

    @Override
    public ValueAdaptor[] getAdaptors() {
        ValueAdaptor[] adaptors = new ValueAdaptor[this._params_count()];
        int i = 0;
        for (PItem item : this.items) {
            i = item.joinAdaptor(this.getEntity(), adaptors, i);
        }
        return adaptors;
    }

    @Override
    public Object[][] getParamMatrix() {
        int pc = this._params_count();
        int row_count = this.rows.size();
        if (this.rows.size() > 1 && this.params.size() == 0 && this.rows.get(0).size() != 0) {
            --row_count;
        }
        Object[][] re = new Object[row_count][pc];
        for (int z = 0; z < row_count; ++z) {
            VarSet row = this.rows.get(z);
            int i = 0;
            for (PItem item : this.items) {
                i = item.joinParams(this.getEntity(), row, re[z], i);
            }
        }
        return re;
    }

    @Override
    public String toPreparedStatement() {
        StringBuilder sb = new StringBuilder();
        for (PItem item : this.items) {
            item.joinSql(this.getEntity(), sb);
        }
        return sb.toString();
    }

    @Override
    public void onBefore(Connection conn) throws SQLException {
    }

    @Override
    public void onAfter(Connection conn, ResultSet rs, Statement stmt) throws SQLException {
        if (this.callback != null) {
            this.getContext().setResult(this.callback.invoke(conn, rs, this));
        }
    }

    @Override
    public DaoStatement setPager(Pager pager) {
        this.getContext().setPager(pager);
        return this;
    }

    @Override
    public VarSet vars() {
        return this.vars;
    }

    @Override
    public VarSet params() {
        return this.params;
    }

    @Override
    public void setValueAdaptor(String name, ValueAdaptor adaptor) {
        this.customValueAdaptor.put(name, adaptor);
    }

    @Override
    public VarIndex varIndex() {
        return this.varIndex;
    }

    @Override
    public VarIndex paramIndex() {
        return this.paramIndex;
    }

    @Override
    public void addBatch() {
        this.params = new SimpleVarSet();
        this.rows.add(this.params);
    }

    @Override
    public void clearBatch() {
        this.params = new SimpleVarSet();
        this.rows.clear();
        this.rows.add(this.params);
    }

    @Override
    public Sql setEntity(Entity<?> entity) {
        super.setEntity(entity);
        return this;
    }

    @Override
    public Sql setCallback(SqlCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public Sql setCondition(Condition cnd) {
        this.vars.set("condition", cnd);
        return this;
    }

    @Override
    public Sql duplicate() {
        return new NutSql(this.sourceSql, this.callback);
    }

    @Override
    public String getSourceSql() {
        return this.sourceSql;
    }

    protected SqlLiteral literal() {
        if (this.placeholder == null) {
            return new SqlLiteral().valueOf(this.sourceSql);
        }
        return new SqlLiteral(this.placeholder[0], this.placeholder[1]).valueOf(this.sourceSql);
    }

    @Override
    public Sql setParam(String name, Object value) {
        this.params().set(name, value);
        return this;
    }

    @Override
    public Sql setVar(String name, Object value) {
        this.vars().set(name, value);
        return this;
    }

    @Override
    public Record getOutParams() {
        return this.getContext().attr(Record.class, "OUT");
    }

    @Override
    public Sql changePlaceholder(char param, char var) {
        this.placeholder = new char[]{param, var};
        this.setSourceSql(this.getSourceSql());
        return null;
    }

    class SqlParamPItem
    extends AbstractPItem {
        private static final long serialVersionUID = 1494513192752663060L;
        public String name;

        public SqlParamPItem(String name) {
            this.name = name;
        }

        @Override
        public void joinSql(Entity<?> en, StringBuilder sb) {
            Object val = NutSql.this.rows.get(0).get(this.name);
            if (val == null) {
                sb.append("?");
            } else if (val instanceof PItem) {
                ((PItem)val).joinSql(en, sb);
            } else if (val.getClass().isArray()) {
                sb.append(Strings.dup("?,", Lang.eleSize(val)));
                sb.setLength(sb.length() - 1);
            } else if (val instanceof Condition) {
                sb.append(' ').append(Pojos.formatCondition(en, (Condition)val));
            } else {
                sb.append("?");
            }
        }

        @Override
        public int joinAdaptor(Entity<?> en, final ValueAdaptor[] adaptors, final int off) {
            ValueAdaptor custom;
            if (!NutSql.this.customValueAdaptor.isEmpty() && (custom = NutSql.this.customValueAdaptor.get(this.name)) != null) {
                adaptors[off] = custom;
                return off + 1;
            }
            Object val = NutSql.this.rows.get(0).get(this.name);
            if (val == null && NutSql.this.rows.size() > 1) {
                VarSet vs;
                Iterator<VarSet> iterator = NutSql.this.rows.iterator();
                while (iterator.hasNext() && (val = (vs = iterator.next()).get(this.name)) == null) {
                }
            }
            if (val == null) {
                adaptors[off] = NutSql.this.getAdapterBy(null);
                return off + 1;
            }
            if (val instanceof PItem) {
                return ((PItem)val).joinAdaptor(en, adaptors, off);
            }
            if (val.getClass().isArray() || Collection.class.isAssignableFrom(val.getClass())) {
                int len = Lang.eleSize(val);
                Lang.each(val, new Each<Object>(){

                    @Override
                    public void invoke(int index, Object ele, int length) {
                        adaptors[off + index] = NutSql.this.getAdapterBy(ele);
                    }
                });
                return off + len;
            }
            adaptors[off] = NutSql.this.getAdapterBy(val);
            return off + 1;
        }

        @Override
        public int joinParams(Entity<?> en, Object obj, final Object[] params, final int off) {
            VarSet row = (VarSet)obj;
            Object val = row.get(this.name);
            if (val == null) {
                return off + 1;
            }
            if (val instanceof PItem) {
                return ((PItem)val).joinParams(en, null, params, off);
            }
            if (val.getClass().isArray()) {
                int len = Lang.eleSize(val);
                Lang.each(val, new Each<Object>(){

                    @Override
                    public void invoke(int index, Object ele, int length) {
                        params[off + index] = ele;
                    }
                });
                return off + len;
            }
            params[off] = val;
            return off + 1;
        }

        @Override
        public int paramCount(Entity<?> en) {
            Object val = NutSql.this.rows.get(0).get(this.name);
            if (val == null) {
                return 1;
            }
            if (val instanceof PItem) {
                return ((PItem)val).paramCount(en);
            }
            if (val.getClass().isArray()) {
                return Lang.eleSize(val);
            }
            if (val instanceof Condition) {
                return 0;
            }
            return 1;
        }
    }

    class SqlVarPItem
    extends AbstractPItem {
        private static final long serialVersionUID = 2655530650031939556L;
        public String name;

        public SqlVarPItem(String name) {
            this.name = name;
        }

        @Override
        public void joinSql(Entity<?> en, StringBuilder sb) {
            Object val = NutSql.this.vars.get(this.name);
            if (val != null) {
                if (val instanceof PItem) {
                    ((PItem)val).joinSql(en, sb);
                } else if (val instanceof Condition) {
                    sb.append(' ').append(Pojos.formatCondition(en, (Condition)val));
                } else {
                    sb.append(val);
                }
            }
        }

        @Override
        public int joinAdaptor(Entity<?> en, ValueAdaptor[] adaptors, int off) {
            Object val = NutSql.this.vars.get(this.name);
            if (val != null && val instanceof PItem) {
                return ((PItem)val).joinAdaptor(en, adaptors, off);
            }
            return off;
        }

        @Override
        public int paramCount(Entity<?> en) {
            Object val = NutSql.this.vars.get(this.name);
            if (val != null && val instanceof PItem) {
                return ((PItem)val).paramCount(en);
            }
            return 0;
        }

        @Override
        public int joinParams(Entity<?> en, Object obj, Object[] params, int off) {
            Object val = NutSql.this.vars.get(this.name);
            if (val != null && val instanceof PItem) {
                return ((PItem)val).joinParams(en, obj, params, off);
            }
            return off;
        }
    }
}

