/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.conf;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.el.opt.custom.CustomMake;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mapl.Mapl;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class NutConf {
    private static final Log log = Logs.get();
    private static final String DEFAULT_CONFIG = "org/nutz/conf/NutzDefaultConfig.js";
    private Map<String, Object> map = new HashMap<String, Object>();
    private static volatile NutConf conf;
    public static boolean USE_FASTCLASS;
    public static boolean USE_MIRROR_CACHE;
    public static boolean USE_EL_IN_OBJECT_CONVERT;
    public static boolean RESOURCE_SCAN_TRACE;
    public static boolean JSON_ALLOW_ILLEGAL_ESCAPE;
    public static boolean JSON_APPEND_ILLEGAL_ESCAPE;
    public static boolean AOP_USE_CLASS_ID;
    public static int AOP_CLASS_LEVEL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NutConf me() {
        if (null != conf) return conf;
        Class<NutConf> clazz = NutConf.class;
        synchronized (NutConf.class) {
            if (null != conf) return conf;
            conf = new NutConf();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    private NutConf() {
        this.loadResource(DEFAULT_CONFIG);
    }

    public static void load(String ... paths) {
        NutConf.me().loadResource(paths);
        CustomMake.me().init();
    }

    private void loadResource(String ... paths) {
        for (String path : paths) {
            List<NutResource> resources = Scans.me().scan(path, "\\.(js|json)$");
            for (NutResource nr : resources) {
                try {
                    Object obj = Json.fromJson(nr.getReader());
                    if (!(obj instanceof Map)) continue;
                    Map m = (Map)obj;
                    this.map = (Map)Mapl.merge(this.map, m);
                    for (Object key : m.keySet()) {
                        if (!key.equals("include")) continue;
                        this.map.remove("include");
                        List include = (List)m.get("include");
                        this.loadResource(include.toArray(new String[include.size()]));
                    }
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Fail to load config?! for " + nr.getName(), e);
                }
            }
        }
    }

    public static Object get(String key, Type type) {
        return NutConf.me().getItem(key, type);
    }

    public static Object get(String key) {
        return NutConf.me().getItem(key, null);
    }

    private Object getItem(String key, Type type) {
        if (null == this.map) {
            return null;
        }
        if (null == type) {
            return this.map.get(key);
        }
        return Mapl.maplistToObj(this.map.get(key), type);
    }

    public static void clear() {
        conf = null;
    }

    static {
        USE_FASTCLASS = !Lang.isAndroid && Lang.JdkTool.getMajorVersion() <= 8;
        USE_MIRROR_CACHE = true;
        USE_EL_IN_OBJECT_CONVERT = false;
        RESOURCE_SCAN_TRACE = false;
        JSON_ALLOW_ILLEGAL_ESCAPE = true;
        JSON_APPEND_ILLEGAL_ESCAPE = false;
        AOP_USE_CLASS_ID = false;
        AOP_CLASS_LEVEL = 50;
    }
}

