/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.lang.Strings;
import org.nutz.lang.meta.Pair;

public class AtMap {
    private Map<String, String> ats = new HashMap<String, String>();
    private Map<String, Method> methods = new HashMap<String, Method>();

    public void add(String key, String actionPath) {
        if (actionPath.endsWith("/*")) {
            actionPath = actionPath.substring(0, actionPath.length() - 2);
        }
        this.ats.put(Strings.trim(key), Strings.trim(actionPath));
    }

    public void addMethod(String url, Method method) {
        this.methods.put(url, method);
    }

    public Set<String> keys() {
        return this.ats.keySet();
    }

    public Map<String, Method> getMethodMapping() {
        return this.methods;
    }

    public int size() {
        return this.ats.size();
    }

    public String get(String key) {
        return this.ats.get(key);
    }

    public AtMap clear() {
        this.ats.clear();
        return this;
    }

    public List<Pair<String>> getAll() {
        return this.getList(null);
    }

    public List<Pair<String>> getList(String ... prefixes) {
        ArrayList<Pair<String>> list = new ArrayList<Pair<String>>(this.ats.size());
        Set<Map.Entry<String, String>> ens = this.ats.entrySet();
        block0: for (Map.Entry<String, String> en : ens) {
            String key = en.getKey();
            if (null == prefixes || prefixes.length == 0) {
                list.add(new Pair<String>(key, en.getValue()));
                continue;
            }
            for (String prefix : prefixes) {
                if (!key.startsWith(prefix)) continue;
                list.add(new Pair<String>(key, en.getValue()));
                continue block0;
            }
        }
        return list;
    }
}

