/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.img;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.nutz.img.Colors;
import org.nutz.img.Fonts;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.repo.Base64;

public class Images {
    public static final int WATERMARK_TOP_LEFT = 1;
    public static final int WATERMARK_TOP_CENTER = 2;
    public static final int WATERMARK_TOP_RIGHT = 3;
    public static final int WATERMARK_CENTER_LEFT = 4;
    public static final int WATERMARK_CENTER = 5;
    public static final int WATERMARK_CENTER_RIGHT = 6;
    public static final int WATERMARK_BOTTOM_LEFT = 7;
    public static final int WATERMARK_BOTTOM_CENTER = 8;
    public static final int WATERMARK_BOTTOM_RIGHT = 9;
    public static final int CHANNEL_RED = 0;
    public static final int CHANNEL_GREEN = 1;
    public static final int CHANNEL_BLUE = 2;

    public static BufferedImage rotate(Object srcIm, File taIm, int degree) {
        BufferedImage im = Images.read(srcIm);
        BufferedImage im2 = Images.rotate(im, degree);
        Images.write(im2, taIm);
        return im2;
    }

    public static BufferedImage rotate(String srcPath, String taPath, int degree) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.rotate(srcIm, taIm, degree);
    }

    public static BufferedImage rotate(BufferedImage image, int degree) {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degree %= 360) < 0) {
            degree = 360 + degree;
        }
        double ang = (double)degree * 0.0174532925;
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
        Graphics2D gs = rotatedImage.createGraphics();
        gs.fillRect(0, 0, w, h);
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 1);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        return image;
    }

    public static BufferedImage zoomScale(Object srcIm, File taIm, int w, int h, Color bgColor) throws IOException {
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.zoomScale(old, w, h, bgColor);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage zoomScale(String srcPath, String taPath, int w, int h, Color bgColor) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.zoomScale(srcIm, taIm, w, h, bgColor);
    }

    public static BufferedImage zoomScale(BufferedImage im, int w, int h, Color bgColor) {
        int y;
        int x;
        int nH;
        int nW;
        float nR;
        int oH;
        if (w == -1 || h == -1) {
            return Images.zoomScale(im, w, h);
        }
        int oW = im.getWidth();
        float oR = (float)oW / (float)(oH = im.getHeight());
        if (oR > (nR = (float)w / (float)h)) {
            nW = w;
            nH = (int)((float)w / oR);
            x = 0;
            y = (h - nH) / 2;
        } else if (oR < nR) {
            nH = h;
            nW = (int)((float)h * oR);
            x = (w - nW) / 2;
            y = 0;
        } else {
            nW = w;
            nH = h;
            x = 0;
            y = 0;
        }
        BufferedImage re = new BufferedImage(w, h, im.getType());
        Graphics2D gc = re.createGraphics();
        if (null != bgColor) {
            gc.setColor(bgColor);
            gc.fillRect(0, 0, w, h);
        }
        gc.drawImage(im, x, y, nW, nH, bgColor, null);
        gc.dispose();
        return re;
    }

    public static BufferedImage zoomScale(BufferedImage im, int w, int h) {
        return Images.zoomScale(im, w, h, null);
    }

    public static BufferedImage scale(BufferedImage im, int w, int h) {
        int oW = im.getWidth();
        int oH = im.getHeight();
        int nW = w;
        int nH = h;
        if (h == -1) {
            nH = (int)((float)w / (float)oW * (float)oH);
        } else if (w == -1) {
            nW = (int)((float)h / (float)oH * (float)oW);
        }
        BufferedImage re = new BufferedImage(nW, nH, im.getType());
        Graphics2D gc = re.createGraphics();
        gc.drawImage(im, 0, 0, nW, nH, null);
        gc.dispose();
        return re;
    }

    public static BufferedImage clipScale(Object srcIm, File taIm, int w, int h) throws IOException {
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.clipScale(old, w, h);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage clipScale(String srcPath, String taPath, int w, int h) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.clipScale((Object)srcIm, taIm, w, h);
    }

    public static BufferedImage clipScale(Object srcIm, int[] startPoint, int[] endPoint) {
        int width = endPoint[0] - startPoint[0];
        int height = endPoint[1] - startPoint[1];
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.clipScale(old.getSubimage(startPoint[0], startPoint[1], width, height), width, height);
        return im;
    }

    public static BufferedImage clipScale(Object srcIm, File taIm, int[] startPoint, int[] endPoint) throws IOException {
        BufferedImage old = Images.read(srcIm);
        BufferedImage im = Images.clipScale((Object)old, startPoint, endPoint);
        Images.write(im, taIm);
        return old;
    }

    public static BufferedImage clipScale(String srcPath, String taPath, int[] startPoint, int[] endPoint) throws IOException {
        File srcIm = Files.findFile(srcPath);
        if (null == srcIm) {
            throw Lang.makeThrow("Fail to find image file '%s'!", srcPath);
        }
        File taIm = Files.createFileIfNoExists(taPath);
        return Images.clipScale((Object)srcIm, taIm, startPoint, endPoint);
    }

    public static BufferedImage clipScale(BufferedImage im, int w, int h) {
        int y;
        int x;
        int nH;
        int nW;
        float nR;
        int oH;
        int oW = im.getWidth();
        float oR = (float)oW / (float)(oH = im.getHeight());
        if (oR > (nR = (float)w / (float)h)) {
            nW = h * oW / oH;
            nH = h;
            x = (w - nW) / 2;
            y = 0;
        } else if (oR < nR) {
            nW = w;
            nH = w * oH / oW;
            x = 0;
            y = (h - nH) / 2;
        } else {
            nW = w;
            nH = h;
            x = 0;
            y = 0;
        }
        BufferedImage re = new BufferedImage(w, h, 5);
        re.createGraphics().drawImage(im, x, y, nW, nH, Color.black, null);
        return re;
    }

    public static BufferedImage flipHorizontal(Object srcIm) {
        BufferedImage im1 = Images.read(srcIm);
        int w = im1.getWidth();
        int h = im1.getHeight();
        BufferedImage flipImage = new BufferedImage(w, h, im1.getType());
        Graphics2D gs = flipImage.createGraphics();
        gs.drawImage(im1, 0, 0, w, h, w, 0, 0, h, null);
        gs.dispose();
        return flipImage;
    }

    public static BufferedImage flipHorizontal(Object srcIm, File tarIm) {
        BufferedImage flipImage = Images.flipHorizontal(srcIm);
        Images.write(flipImage, tarIm);
        return flipImage;
    }

    public static BufferedImage flipVertical(Object srcIm) {
        BufferedImage im1 = Images.read(srcIm);
        int w = im1.getWidth();
        int h = im1.getHeight();
        BufferedImage flipImage = new BufferedImage(w, h, im1.getType());
        Graphics2D gs = flipImage.createGraphics();
        gs.drawImage(im1, 0, 0, w, h, 0, h, w, 0, null);
        gs.dispose();
        return flipImage;
    }

    public static BufferedImage flipVertical(Object srcIm, File tarIm) {
        BufferedImage flipImage = Images.flipVertical(srcIm);
        Images.write(flipImage, tarIm);
        return flipImage;
    }

    public static BufferedImage twist(Object srcIm, double twistRank, String bgColor) {
        if (twistRank <= 0.0) {
            twistRank = 1.0;
        }
        BufferedImage bufImg = Images.read(srcIm);
        double period = R.random(0, 7) + 3;
        double phase = R.random(0, 6);
        int width = bufImg.getWidth();
        int height = bufImg.getHeight();
        BufferedImage tarIm = new BufferedImage(width, height, 1);
        Graphics2D gc = tarIm.createGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setBackground(Strings.isBlank(bgColor) ? Colors.randomColor() : Colors.as(bgColor));
        gc.clearRect(0, 0, width, height);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int nX = Images.pos4twist(twistRank, phase, period, height, i, j);
                int nY = j;
                if (nX < 0 || nX >= width || nY < 0 || nY >= height) continue;
                tarIm.setRGB(nX, nY, bufImg.getRGB(i, j));
            }
        }
        return tarIm;
    }

    private static int pos4twist(double rank, double phase, double period, int hOrW, int xOrY, int yOrX) {
        double dyOrX = Math.PI * rank * (double)yOrX / (double)hOrW + phase;
        double dxOrY = Math.sin(dyOrX);
        return xOrY + (int)(dxOrY * period);
    }

    public static BufferedImage addWatermark(Object srcIm, Object markIm, float opacity, int pos, int margin) {
        BufferedImage im1 = Images.read(srcIm);
        BufferedImage im2 = Images.read(markIm);
        int cw = im1.getWidth();
        int ch = im1.getHeight();
        int mw = im2.getWidth();
        int mh = im2.getHeight();
        if (opacity > 1.0f || opacity <= 0.0f) {
            opacity = 0.5f;
        }
        if (pos > 9 || pos <= 0) {
            pos = 5;
        }
        int px = 0;
        int py = 0;
        switch (pos) {
            case 1: {
                px = margin;
                py = margin;
                break;
            }
            case 2: {
                px = (cw - mw) / 2;
                py = margin;
                break;
            }
            case 3: {
                px = cw - mw - margin;
                py = margin;
                break;
            }
            case 4: {
                px = margin;
                py = (ch - mh) / 2;
                break;
            }
            case 5: {
                px = (cw - mw) / 2;
                py = (ch - mh) / 2;
                break;
            }
            case 6: {
                px = cw - mw - margin;
                py = (ch - mh) / 2;
                break;
            }
            case 7: {
                px = margin;
                py = ch - mh - margin;
                break;
            }
            case 8: {
                px = (cw - mw) / 2;
                py = ch - mh - margin;
                break;
            }
            case 9: {
                px = cw - mw - margin;
                py = ch - mh - margin;
            }
        }
        Graphics2D gs = im1.createGraphics();
        gs.setComposite(AlphaComposite.getInstance(10, opacity));
        gs.drawImage((Image)im2, px, py, null);
        gs.dispose();
        return im1;
    }

    public static BufferedImage grayImage(Object srcIm) {
        BufferedImage srcImage = Images.read(srcIm);
        BufferedImage grayImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), srcImage.getType());
        for (int i = 0; i < srcImage.getWidth(); ++i) {
            for (int j = 0; j < srcImage.getHeight(); ++j) {
                grayImage.setRGB(i, j, Colors.getGray(srcImage, i, j));
            }
        }
        return grayImage;
    }

    public static BufferedImage multiply(Object bgIm, Object itemIm, int x, int y) {
        BufferedImage viewportImage = Images.read(bgIm);
        BufferedImage itemImage = Images.read(itemIm);
        BufferedImage muImage = new BufferedImage(viewportImage.getWidth(), viewportImage.getHeight(), viewportImage.getType());
        int xMin = x;
        int xMax = x + itemImage.getWidth();
        int yMin = y;
        int yMax = y + itemImage.getHeight();
        for (int i = 0; i < viewportImage.getWidth(); ++i) {
            for (int j = 0; j < viewportImage.getHeight(); ++j) {
                int rgb = 0;
                if (i >= xMin && i < xMax && j >= yMin && j < yMax) {
                    int vpRGB = viewportImage.getRGB(i, j);
                    int imRGB = itemImage.getRGB(i - x, j - y);
                    rgb = Colors.getMultiply(vpRGB, imRGB);
                } else {
                    rgb = viewportImage.getRGB(i, j);
                }
                muImage.setRGB(i, j, rgb);
            }
        }
        return muImage;
    }

    public static BufferedImage cutoutByLuminance(Object srcIm) {
        return Images.cutoutByChannel(srcIm, -1);
    }

    public static BufferedImage cutoutByChannel(Object srcIm, int channel) {
        BufferedImage srcImage = Images.read(srcIm);
        BufferedImage resultImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 6);
        for (int i = 0; i < srcImage.getWidth(); ++i) {
            for (int j = 0; j < srcImage.getHeight(); ++j) {
                int pixel = srcImage.getRGB(i, j);
                int alpha = 0;
                switch (channel) {
                    case 0: {
                        alpha = Colors.getRGB(pixel)[0];
                        break;
                    }
                    case 1: {
                        alpha = Colors.getRGB(pixel)[1];
                        break;
                    }
                    case 2: {
                        alpha = Colors.getRGB(pixel)[2];
                        break;
                    }
                    default: {
                        alpha = Colors.getLuminance(srcImage, i, j);
                    }
                }
                pixel = alpha << 24 & 0xFF000000 | pixel & 0xFFFFFF;
                resultImage.setRGB(i, j, pixel);
            }
        }
        return resultImage;
    }

    public static BufferedImage cutoutByPixel(Object srcIm, int x, int y, int range) {
        BufferedImage srcImage = Images.read(srcIm);
        BufferedImage resultImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 6);
        int[] srgb = Colors.getRGB(srcImage.getRGB(x, y));
        for (int i = 0; i < srcImage.getWidth(); ++i) {
            for (int j = 0; j < srcImage.getHeight(); ++j) {
                int pixel = srcImage.getRGB(i, j);
                int[] crgb = Colors.getRGB(pixel);
                int alpha = 255;
                alpha = Images.inRangeColor(srgb, crgb, range) ? 0 : (Images.inRangeColor(srgb, crgb, (int)((double)range * 1.5)) ? 64 : (Images.inRangeColor(srgb, crgb, range * 2) ? 128 : Colors.getAlpha(pixel)));
                pixel = alpha << 24 & 0xFF000000 | pixel & 0xFFFFFF;
                resultImage.setRGB(i, j, pixel);
            }
        }
        return resultImage;
    }

    private static boolean inRangeColor(int[] srgb, int[] crgb, int range) {
        return crgb[0] >= srgb[0] - range && crgb[0] <= srgb[0] + range && crgb[1] >= srgb[1] - range && crgb[1] <= srgb[1] + range && crgb[2] >= srgb[2] - range && crgb[2] <= srgb[2] + range;
    }

    public static BufferedImage channelImage(Object srcIm, int channel) {
        BufferedImage srcImage = Images.read(srcIm);
        BufferedImage rcImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), srcImage.getType());
        for (int i = 0; i < srcImage.getWidth(); ++i) {
            for (int j = 0; j < srcImage.getHeight(); ++j) {
                int r = Colors.getRGB(srcImage, i, j)[channel];
                rcImage.setRGB(i, j, new Color(r, r, r).getRGB());
            }
        }
        return rcImage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferedImage read(Object img) {
        BufferedImage bufferedImage;
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        if (img instanceof CharSequence) {
            return ImageIO.read(Files.checkFile(img.toString()));
        }
        if (img instanceof File) {
            return ImageIO.read((File)img);
        }
        if (img instanceof URL) {
            img = ((URL)img).openStream();
        }
        if (!(img instanceof InputStream)) throw Lang.makeThrow("Unkown img info!! --> " + img, new Object[0]);
        File tmp = File.createTempFile("nutz_img", ".jpg");
        Files.write(tmp, img);
        try {
            bufferedImage = Images.read(tmp);
            tmp.delete();
        }
        catch (Throwable throwable) {
            try {
                tmp.delete();
                throw throwable;
            }
            catch (IOException e) {
                try {
                    InputStream in = null;
                    if (img instanceof File) {
                        in = new FileInputStream((File)img);
                    } else if (img instanceof URL) {
                        in = ((URL)img).openStream();
                    } else if (img instanceof InputStream) {
                        in = (InputStream)img;
                    }
                    if (in == null) return null;
                    return Images.readJpeg(in);
                }
                catch (IOException e2) {
                    e2.fillInStackTrace();
                }
                return null;
            }
        }
        return bufferedImage;
    }

    public static void write(RenderedImage im, File targetFile) {
        try {
            ImageIO.write(im, Files.getSuffixName(targetFile), targetFile);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void write(RenderedImage im, String imFormat, OutputStream out) {
        try {
            ImageIO.write(im, imFormat, out);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static void writeAndClose(RenderedImage im, String imFormat, OutputStream out) {
        try {
            ImageIO.write(im, imFormat, out);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(out);
        }
    }

    public static void writeJpeg(RenderedImage im, Object targetJpg, float quality) {
        ImageWriter writer = null;
        try {
            writer = ImageIO.getImageWritersBySuffix("jpg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            ImageOutputStream os = ImageIO.createImageOutputStream(targetJpg);
            writer.setOutput(os);
            writer.write(null, new IIOImage(im, null, null), param);
            os.flush();
            os.close();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readJpeg(InputStream in) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        ImageReader reader = null;
        while (readers.hasNext() && !(reader = readers.next()).canReadRaster()) {
        }
        if (reader == null) {
            return null;
        }
        try {
            ImageInputStream input = ImageIO.createImageInputStream(in);
            reader.setInput(input);
            Raster raster = reader.readRaster(0, null);
            BufferedImage image = Images.createJPEG4(raster);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Images.writeJpeg(image, out, 1.0f);
            out.flush();
            BufferedImage bufferedImage = Images.read(new ByteArrayInputStream(out.toByteArray()));
            return bufferedImage;
        }
        finally {
            try {
                reader.dispose();
            }
            catch (Throwable throwable) {}
        }
    }

    private static BufferedImage createJPEG4(Raster raster) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        float[] K = raster.getSamples(0, 0, w, h, 3, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float k = 220.0f - K[i];
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f) - (double)k;
            rgb[base] = (byte)((val = (val - 128.0) * (double)0.65f + 128.0) < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f) - (double)k;
            val = (val - 128.0) * (double)0.65f + 128.0;
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, new int[]{0, 1, 2}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }

    public static String encodeBase64(String targetFile) {
        return Images.encodeBase64(new File(targetFile));
    }

    public static String encodeBase64(File targetFile) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(targetFile);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        image.flush();
        try {
            ImageIO.write((RenderedImage)image, Files.getSuffixName(targetFile), bos);
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        byte[] bImage = baos.toByteArray();
        return Base64.encodeToString(bImage, false);
    }

    public static BufferedImage redraw(BufferedImage img, Color bg) {
        BufferedImage rgbImage = new BufferedImage(img.getWidth(), img.getHeight(), 5);
        Graphics2D g2d = rgbImage.createGraphics();
        g2d.drawImage(img, 0, 0, bg, null);
        g2d.dispose();
        return rgbImage;
    }

    public static BufferedImage createText(String content) {
        return Images.createText(content, 0, 0, null, null, null, 0, 0);
    }

    public static BufferedImage createText(String content, int width, int height, String fontColor, String bgColor, String fontName, int fontSize, int fontStyle) {
        if (Strings.isBlank(content)) {
            return null;
        }
        if (width <= 0) {
            width = 256;
        }
        if (height <= 0) {
            height = 256;
        }
        if (Strings.isBlank(fontColor)) {
            fontColor = "#FFF";
        }
        if (Strings.isBlank(bgColor)) {
            bgColor = "#000";
        }
        if (fontSize <= 0) {
            fontSize = height / 2;
        }
        if (fontStyle < 0 || fontStyle > 2) {
            fontStyle = 1;
        }
        Color colorFont = Colors.as(fontColor);
        Color colorBg = Colors.as(bgColor);
        int imageType = 1;
        if (colorFont.getAlpha() < 255 || colorBg.getAlpha() < 255) {
            imageType = 2;
        }
        BufferedImage im = new BufferedImage(width, height, imageType);
        Graphics2D gc = im.createGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setBackground(colorBg);
        gc.clearRect(0, 0, width, height);
        Font cFont = Fonts.get(fontName, fontStyle, fontSize);
        gc.setColor(colorFont);
        gc.setFont(cFont);
        FontMetrics cFontM = gc.getFontMetrics(cFont);
        int cW = cFontM.stringWidth(content);
        int ascent = cFontM.getAscent();
        int descent = cFontM.getDescent();
        int x = width / 2 - cW / 2;
        int y = (height - (ascent + descent)) / 2 + ascent;
        gc.drawString(content, x, y);
        return im;
    }

    public static BufferedImage createAvatar(String name) {
        return Images.createAvatar(name, 0, null, null, null, 0, 1);
    }

    public static BufferedImage createAvatar(String name, int size, String fontColor, String bgColor, String fontName, int fontSize, int fontStyle) {
        if (Strings.isBlank(name)) {
            return null;
        }
        String content = name;
        if (name.length() > 2) {
            content = "" + name.charAt(0);
        }
        content = content.toUpperCase();
        return Images.createText(content, size, size, fontColor, bgColor, fontName, fontSize, fontStyle);
    }

    public static BufferedImage createCaptcha(String content) {
        return Images.createCaptcha(content, 0, 0, null, "FFF", null);
    }

    public static BufferedImage createCaptcha(String content, int width, int height, String fontColor, String bgColor, String fontName) {
        if (Strings.isBlank(content)) {
            return null;
        }
        boolean isChinese = Strings.isChineseCharacter(content.charAt(0));
        if (width <= 0) {
            width = content.length() * (isChinese ? 25 : 20) + 20;
        }
        if (height <= 0) {
            height = 30;
        }
        Color userColor = Strings.isBlank(fontColor) ? null : Colors.as(fontColor);
        Color colorBg = Strings.isBlank(bgColor) ? Colors.randomColor() : Colors.as(bgColor);
        BufferedImage im = new BufferedImage(width, height, 1);
        Graphics2D gc = im.createGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setBackground(colorBg);
        gc.clearRect(0, 0, width, height);
        for (int i = 0; i < 7; ++i) {
            gc.setColor(userColor == null ? Colors.randomColor(5, 250) : userColor);
            int x = R.random(0, width);
            int y = R.random(0, height);
            int x1 = R.random(0, width);
            int y1 = R.random(0, height);
            gc.drawLine(x, y, x1, y1);
        }
        int rx = 10;
        int ry = isChinese ? height - 8 : height - 10;
        for (int i = 0; i < content.length(); ++i) {
            int fontStyle = R.random(0, 3);
            int fontSize = R.random(height - 10, height - 5);
            Font textFont = Strings.isBlank(fontName) ? Fonts.random(fontStyle, fontSize) : Fonts.get(fontName, fontStyle, fontSize);
            gc.setColor(userColor == null ? Colors.randomColor(10, 250) : userColor);
            gc.setFont(textFont);
            int degree = R.random(0, 64) % 30;
            gc.rotate((double)degree * Math.PI / 180.0, rx, ry);
            gc.drawString(content.charAt(i) + "", rx, ry);
            gc.rotate((double)(-degree) * Math.PI / 180.0, rx, ry);
            rx += (isChinese ? 5 : 0) + width / (content.length() + 2);
        }
        im = Images.twist(im, 1.0, bgColor);
        return im;
    }
}

