/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.nutz.http.Cookie;
import org.nutz.http.Header;
import org.nutz.http.Http;
import org.nutz.http.HttpException;
import org.nutz.http.HttpReqRespInterceptor;
import org.nutz.http.ProxySwitcher;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.sender.FilePostSender;
import org.nutz.http.sender.GetSender;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.Lang;
import org.nutz.lang.stream.VoidInputStream;
import org.nutz.lang.util.Callback;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class Sender
implements Callable<Response> {
    public static int Default_Conn_Timeout = 30000;
    public static int Default_Read_Timeout = 600000;
    private static final Log log = Logs.get();
    protected Request request;
    private int connTimeout;
    private int timeout;
    protected HttpURLConnection conn;
    protected HttpReqRespInterceptor interceptor = new Cookie();
    protected Callback<Response> callback;
    protected boolean followRedirects = true;
    protected SSLSocketFactory sslSocketFactory;
    protected Callback<Integer> progressListener;
    protected static ExecutorService es;

    public static Sender create(String url) {
        return Sender.create(Request.get(url));
    }

    public static Sender create(String url, int timeout) {
        return Sender.create(url).setTimeout(timeout);
    }

    public static Sender create(Request request) {
        if (request.isGet() || request.isDelete()) {
            return new GetSender(request);
        }
        if ((request.isPost() || request.isPut()) && request.getParams() != null) {
            for (Object val : request.getParams().values()) {
                if (!(val instanceof File) && !(val instanceof File[])) continue;
                return new FilePostSender(request);
            }
        }
        return new PostSender(request);
    }

    public static Sender create(Request request, int timeout) {
        return Sender.create(request).setTimeout(timeout);
    }

    protected Sender(Request request) {
        this.request = request;
    }

    public abstract Response send() throws HttpException;

    protected Response createResponse(Map<String, String> reHeaders) throws IOException {
        Response rep = null;
        if (reHeaders != null) {
            rep = new Response(this.conn, reHeaders);
            if (rep.isOK()) {
                InputStream is1 = this.conn.getInputStream();
                InputStream is2 = null;
                String encoding = this.conn.getContentEncoding();
                is2 = encoding != null && encoding.contains("gzip") ? new GZIPInputStream(is1) : (encoding != null && encoding.contains("deflate") ? new InflaterInputStream(is1, new Inflater(true)) : is1);
                BufferedInputStream is = new BufferedInputStream(is2);
                rep.setStream(is);
            } else {
                try {
                    rep.setStream(this.conn.getInputStream());
                }
                catch (IOException e) {
                    try {
                        rep.setStream(this.conn.getErrorStream());
                    }
                    catch (Exception e1) {
                        rep.setStream(new VoidInputStream());
                    }
                }
            }
        }
        if (this.interceptor != null) {
            this.interceptor.afterResponse(this.request, this.conn, rep);
        }
        return rep;
    }

    protected Map<String, String> getResponseHeader() throws IOException {
        if (this.conn.getResponseCode() < 0) {
            throw new IOException("Network error!! resp code=" + this.conn.getResponseCode());
        }
        HashMap<String, String> reHeaders = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> en : this.conn.getHeaderFields().entrySet()) {
            List<String> val = en.getValue();
            if (null == val || val.size() <= 0) continue;
            reHeaders.put(en.getKey(), en.getValue().get(0));
        }
        return reHeaders;
    }

    protected void setupDoInputOutputFlag() {
        this.conn.setDoInput(true);
        this.conn.setDoOutput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openConnection() throws IOException {
        int connTime;
        block23: {
            if (this.interceptor != null) {
                this.interceptor.beforeConnect(this.request);
            }
            ProxySwitcher proxySwitcher = Http.proxySwitcher;
            int n = connTime = this.connTimeout > 0 ? this.connTimeout : Default_Conn_Timeout;
            if (proxySwitcher != null) {
                try {
                    Proxy proxy = proxySwitcher.getProxy(this.request);
                    if (proxy == null) break block23;
                    if (Http.autoSwitch) {
                        Socket socket = null;
                        try {
                            socket = new Socket();
                            socket.connect(proxy.address(), connTime);
                            OutputStream out = socket.getOutputStream();
                            out.write(10);
                            out.flush();
                        }
                        finally {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                    }
                    log.debug("connect via proxy : " + proxy + " for " + this.request.getUrl());
                    this.conn = (HttpURLConnection)this.request.getUrl().openConnection(proxy);
                    this.conn.setConnectTimeout(connTime);
                    this.conn.setInstanceFollowRedirects(this.followRedirects);
                    if (this.timeout > 0) {
                        this.conn.setReadTimeout(this.timeout);
                    } else {
                        this.conn.setReadTimeout(Default_Read_Timeout);
                    }
                    return;
                }
                catch (IOException e) {
                    if (!Http.autoSwitch) {
                        throw e;
                    }
                    log.info("Test proxy FAIl, fallback to direct connection", e);
                }
            }
        }
        URL url = this.request.getUrl();
        String host = url.getHost();
        this.conn = (HttpURLConnection)url.openConnection();
        if (this.conn instanceof HttpsURLConnection) {
            if (this.sslSocketFactory != null) {
                ((HttpsURLConnection)this.conn).setSSLSocketFactory(this.sslSocketFactory);
            } else if (Http.sslSocketFactory != null) {
                ((HttpsURLConnection)this.conn).setSSLSocketFactory(Http.sslSocketFactory);
            }
        }
        if (!Lang.isIPv4Address(host)) {
            if (url.getPort() > 0 && url.getPort() != 80) {
                host = host + ":" + url.getPort();
            }
            this.conn.addRequestProperty("Host", host);
        }
        this.conn.setConnectTimeout(connTime);
        if (this.request.getMethodString() == null) {
            this.conn.setRequestMethod(this.request.getMethod().name());
        } else {
            this.conn.setRequestMethod(this.request.getMethodString());
        }
        if (this.timeout > 0) {
            this.conn.setReadTimeout(this.timeout);
        } else {
            this.conn.setReadTimeout(Default_Read_Timeout);
        }
        this.conn.setInstanceFollowRedirects(this.followRedirects);
        if (this.interceptor != null) {
            this.interceptor.afterConnect(this.request, this.conn);
        }
    }

    protected void setupRequestHeader() {
        Header header = this.request.getHeader();
        if (null != header) {
            for (Map.Entry<String, String> entry : header.getAll()) {
                this.conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public Sender setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public Sender setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public Sender setInterceptor(HttpReqRespInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Sender setCallback(Callback<Response> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public Response call() throws Exception {
        Response resp = this.send();
        if (this.callback != null) {
            this.callback.invoke(resp);
        }
        return resp;
    }

    public Future<Response> send(Callback<Response> callback) throws HttpException {
        if (es == null) {
            throw new IllegalStateException("Sender ExecutorService is null, Call setup first");
        }
        this.callback = callback;
        return es.submit(this);
    }

    public static ExecutorService setup(ExecutorService es) {
        if (Sender.es != null) {
            Sender.shutdown();
        }
        if (es == null) {
            es = Executors.newFixedThreadPool(64);
        }
        Sender.es = es;
        return es;
    }

    public static List<Runnable> shutdown() {
        ExecutorService _es = es;
        es = null;
        if (_es == null) {
            return null;
        }
        return _es.shutdownNow();
    }

    public static ExecutorService getExecutorService() {
        return es;
    }

    public Sender setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    protected OutputStream getOutputStream() throws IOException {
        OutputStream out = this.conn.getOutputStream();
        if (this.progressListener == null) {
            return out;
        }
        return new FilterOutputStream(out){
            int count;

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                this.count += len;
                Sender.this.progressListener.invoke(this.count);
            }
        };
    }

    public int getEstimationSize() throws IOException {
        return 0;
    }

    public Sender setProgressListener(Callback<Integer> progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }
}

