/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.macro;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.jdbc.NutPojo;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlType;
import org.nutz.lang.Lang;

public class SqlFieldMacro
extends NutPojo {
    private static final long serialVersionUID = -3404648162248580014L;
    private Sql sql;
    private MappingField entityField;
    private boolean shallDuplicate;

    private SqlFieldMacro() {
    }

    public SqlFieldMacro(MappingField field, String str) {
        this.entityField = field;
        this.sql = Sqls.create(str);
        this.setSqlType(this.sql.getSqlType());
        this.setEntity(field.getEntity());
        this.shallDuplicate = this.sql.varIndex().size() > 0 || this.sql.paramIndex().size() > 0;
    }

    @Override
    public Pojo setOperatingObject(Object obj) {
        super.setOperatingObject(obj);
        if (null != obj) {
            Entity<?> en = this.entityField.getEntity();
            if (!en.getType().isInstance(obj)) {
                throw Lang.makeThrow("Invalid operating object '%s' for field '%s'", obj.getClass().getName(), this.entityField.toString());
            }
            this.prepareVarParam(this.sql);
        }
        return this;
    }

    @Override
    public void onAfter(Connection conn, ResultSet rs, Statement stmt) throws SQLException {
        if (rs != null && rs.next()) {
            String colName = rs.getMetaData().getColumnName(1);
            Object obj = this.entityField.getAdaptor().get(rs, colName);
            this.entityField.setValue(this.getOperatingObject(), obj);
        }
    }

    @Override
    public SqlType getSqlType() {
        return this.sql.getSqlType();
    }

    @Override
    public ValueAdaptor[] getAdaptors() {
        return this.sql.getAdaptors();
    }

    @Override
    public Object[][] getParamMatrix() {
        return this._parseSQL().getParamMatrix();
    }

    @Override
    public String toPreparedStatement() {
        return this._parseSQL().toPreparedStatement();
    }

    @Override
    public Pojo duplicate() {
        SqlFieldMacro re = new SqlFieldMacro();
        re.sql = this.sql.duplicate();
        re.entityField = this.entityField;
        re.setSqlType(this.sql.getSqlType());
        re.setEntity(this.entityField.getEntity());
        re.shallDuplicate = this.shallDuplicate;
        return re;
    }

    private Sql _parseSQL() {
        if (!this.shallDuplicate) {
            return this.sql;
        }
        Sql sql = this.sql.duplicate();
        this.prepareVarParam(sql);
        return sql;
    }

    protected void prepareVarParam(Sql sql) {
        for (String name : sql.varIndex().names()) {
            if ("view".equals(name)) {
                sql.vars().set("view", this.getEntity().getViewName());
                continue;
            }
            if ("table".equals(name)) {
                sql.vars().set("table", this.getEntity().getTableName());
                continue;
            }
            if ("field".equals(name)) {
                sql.vars().set("field", this.entityField.getColumnName());
                continue;
            }
            sql.vars().set(name, this.getFieldVale(name, this.getOperatingObject()));
        }
        for (String name : sql.paramIndex().names()) {
            if ("view".equals(name)) {
                sql.params().set("view", this.getEntity().getViewName());
                continue;
            }
            if ("table".equals(name)) {
                sql.params().set("table", this.getEntity().getTableName());
                continue;
            }
            if ("field".equals(name)) {
                sql.params().set("field", this.entityField.getColumnName());
                continue;
            }
            sql.params().set(name, this.getFieldVale(name, this.getOperatingObject()));
        }
    }

    protected Object getFieldVale(String name, Object obj) {
        MappingField mf = this.getEntity().getField(name);
        if (mf == null) {
            return this.getEntity().getMirror().getEjecting(name).eject(obj);
        }
        return mf.getValue(obj);
    }
}

