/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.filepool.NutFilePool;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.adaptor.PairAdaptor;
import org.nutz.mvc.adaptor.ParamInjector;
import org.nutz.mvc.annotation.Param;
import org.nutz.mvc.upload.FastUploading;
import org.nutz.mvc.upload.FieldMeta;
import org.nutz.mvc.upload.Html5Uploading;
import org.nutz.mvc.upload.TempFile;
import org.nutz.mvc.upload.UploadException;
import org.nutz.mvc.upload.UploadingContext;
import org.nutz.mvc.upload.Uploads;
import org.nutz.mvc.upload.injector.FileInjector;
import org.nutz.mvc.upload.injector.FileMetaInjector;
import org.nutz.mvc.upload.injector.InputStreamInjector;
import org.nutz.mvc.upload.injector.MapSelfInjector;
import org.nutz.mvc.upload.injector.ReaderInjector;
import org.nutz.mvc.upload.injector.TempFileArrayInjector;
import org.nutz.mvc.upload.injector.TempFileInjector;

public class UploadAdaptor
extends PairAdaptor {
    private static final Log log = Logs.get();
    private UploadingContext context;

    public UploadAdaptor() throws IOException {
        this.context = new UploadingContext(File.createTempFile("nutz", null).getParent());
    }

    public UploadAdaptor(UploadingContext context) {
        this.context = context;
    }

    public UploadAdaptor(String path) {
        this.context = new UploadingContext(path);
    }

    public UploadAdaptor(String path, int buffer) {
        this(path);
        this.context.setBufferSize(buffer);
    }

    public UploadAdaptor(String path, int buffer, String charset) {
        this(path);
        this.context.setBufferSize(buffer);
        this.context.setCharset(charset);
    }

    public UploadAdaptor(String path, int buffer, String charset, int poolSize) {
        this.context = new UploadingContext(new NutFilePool(path, poolSize));
        this.context.setBufferSize(buffer);
        this.context.setCharset(charset);
    }

    public UploadAdaptor(String path, int buffer, String charset, int poolSize, int maxFileSize) {
        this.context = new UploadingContext(new NutFilePool(path, poolSize));
        this.context.setBufferSize(buffer);
        this.context.setCharset(charset);
        this.context.setMaxFileSize(maxFileSize);
    }

    public UploadingContext getContext() {
        return this.context;
    }

    @Override
    public Object[] adapt(ServletContext sc, HttpServletRequest req, HttpServletResponse resp, String[] pathArgs) {
        if (!Mvcs.getActionContext().getMethod().toGenericString().equals(this.method.toGenericString())) {
            throw new IllegalArgumentException(String.format("Method miss match: expect %s but %s. using Ioc? set singleton=false, pls", this.method, Mvcs.getActionContext().getMethod()));
        }
        return super.adapt(sc, req, resp, pathArgs);
    }

    @Override
    protected ParamInjector evalInjectorBy(Type type, Param param) {
        Class<?> clazz = Lang.getTypeClass(type);
        if (clazz == null) {
            if (log.isWarnEnabled()) {
                log.warnf("!!Fail to get Type Class : type=%s , param=%s", type, param);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapSelfInjector();
        }
        if (null == param) {
            return super.evalInjectorBy(type, null);
        }
        String paramName = param.value();
        if (File.class.isAssignableFrom(clazz)) {
            return new FileInjector(paramName);
        }
        if (FieldMeta.class.isAssignableFrom(clazz)) {
            return new FileMetaInjector(paramName);
        }
        if (TempFile.class.isAssignableFrom(clazz)) {
            return new TempFileInjector(paramName);
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return new InputStreamInjector(paramName);
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return new ReaderInjector(paramName);
        }
        if (TempFile[].class.isAssignableFrom(clazz)) {
            return new TempFileArrayInjector(paramName);
        }
        return super.evalInjectorBy(type, param);
    }

    @Override
    public Map<String, Object> getReferObject(ServletContext sc, HttpServletRequest request, HttpServletResponse response, String[] pathArgs) {
        try {
            if (!"POST".equals(request.getMethod()) && !"PUT".equals(request.getMethod())) {
                String str = "Not POST or PUT, Wrong HTTP method! --> " + request.getMethod();
                throw new UploadException(str);
            }
            String contentType = request.getContentType();
            if (contentType == null) {
                throw new UploadException("Content-Type is NULL!!");
            }
            if (contentType.contains("multipart/form-data")) {
                if (log.isDebugEnabled()) {
                    log.debug("Select Html4 Form upload parser --> " + request.getRequestURI());
                }
                FastUploading ing = new FastUploading();
                Map<String, Object> map = ing.parse(request, this.context);
                return map;
            }
            if (contentType.contains("application/octet-stream")) {
                if (log.isDebugEnabled()) {
                    log.debug("Select Html5 Stream upload parser --> " + request.getRequestURI());
                }
                Html5Uploading ing = new Html5Uploading();
                Map<String, Object> map = ing.parse(request, this.context);
                return map;
            }
            try {
                if (contentType.contains("application/x-www-form-urlencoded")) {
                    log.warn("Using form upload ? You forgot this --> enctype='multipart/form-data' ?");
                }
                throw new UploadException("Unknow Content-Type : " + contentType);
            }
            catch (UploadException e) {
                throw Lang.wrapThrow(e);
            }
        }
        finally {
            Uploads.removeInfo(request);
        }
    }

    @Override
    public void init(Method method) {
        if (this.method != null) {
            throw new RuntimeException(new UploadException("Duplicate initialization is not allowed."));
        }
        super.init(method);
    }
}

