/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.nutz.lang.Lang;
import org.nutz.lang.reflect.FastClassFactory;
import org.nutz.lang.reflect.FastMethod;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.impl.processor.AbstractProcessor;

public class MethodInvokeProcessor
extends AbstractProcessor {
    protected FastMethod fm;

    @Override
    public void process(ActionContext ac) throws Throwable {
        Object module = ac.getModule();
        Method method = ac.getMethod();
        Object[] args = ac.getMethodArgs();
        try {
            if (Mvcs.disableFastClassInvoker) {
                ac.setMethodReturn(method.invoke(module, args));
            } else {
                this._check(method);
                ac.setMethodReturn(this.fm.invoke(module, args));
            }
            this.doNext(ac);
        }
        catch (IllegalAccessException e) {
            throw Lang.unwrapThrow(e);
        }
        catch (IllegalArgumentException e) {
            throw Lang.unwrapThrow(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _check(Method method) {
        if (this.fm != null) {
            return;
        }
        MethodInvokeProcessor methodInvokeProcessor = this;
        synchronized (methodInvokeProcessor) {
            if (this.fm != null) {
                return;
            }
            this.fm = FastClassFactory.get(method);
        }
    }
}

