/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nutz.castor.Castors;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.inject.Injecting;
import org.nutz.lang.util.Disks;
import org.nutz.lang.util.FileVisitor;
import org.nutz.lang.util.MultiLineProperties;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public class PropertiesProxy
extends MultiLineProperties {
    private static final Log log = Logs.get();
    private final boolean utf8;
    private boolean ignoreResourceNotFound = false;

    public PropertiesProxy() {
        this(true);
    }

    public PropertiesProxy(boolean utf8, String ... paths) {
        this(utf8);
        this.setPaths(paths);
    }

    public PropertiesProxy(boolean utf8) {
        this.utf8 = utf8;
    }

    public PropertiesProxy(String ... paths) {
        this(true);
        this.setPaths(paths);
    }

    public PropertiesProxy(InputStream in) {
        this(true);
        try {
            this.load(new InputStreamReader(in));
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(in);
        }
    }

    public PropertiesProxy(Reader r) {
        this(true);
        try {
            this.load(r);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaths(String ... paths) {
        this.clear();
        try {
            List<NutResource> list = this.getResources(paths);
            if (this.utf8) {
                for (NutResource nr : list) {
                    if (log.isDebugEnabled()) {
                        log.debug("load properties from " + nr);
                    }
                    Reader r = nr.getReader();
                    try {
                        this.load(nr.getReader(), false);
                    }
                    finally {
                        Streams.safeClose(r);
                    }
                }
            } else {
                Properties p = new Properties();
                for (NutResource nr : list) {
                    BufferedReader bf = new BufferedReader(new InputStreamReader(nr.getInputStream()));
                    try {
                        p.load(bf);
                    }
                    finally {
                        Streams.safeClose(bf);
                    }
                }
                this.putAll((Map)p);
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    private List<NutResource> getResources(String ... paths) {
        ArrayList<NutResource> list = new ArrayList<NutResource>();
        for (String path : paths) {
            try {
                List<NutResource> resources = Scans.me().loadResource("^.+[.]properties$", path);
                list.addAll(resources);
            }
            catch (Exception e) {
                if (this.ignoreResourceNotFound) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Could not load resource from " + path + ": " + e.getMessage());
                    continue;
                }
                throw Lang.wrapThrow(e);
            }
        }
        return list;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    public boolean has(String key) {
        return this.containsKey(key);
    }

    public PropertiesProxy set(String key, String val) {
        this.put(key, val);
        return this;
    }

    public String check(String key) {
        String val = this.get(key);
        if (null == val) {
            throw Lang.makeThrow("Ioc.$conf expect property '%s'", key);
        }
        return val;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean dfval) {
        String val = this.get(key);
        if (Strings.isBlank(val)) {
            return dfval;
        }
        return Castors.me().castTo(val, Boolean.class);
    }

    public String get(String key, String defaultValue) {
        return Strings.sNull(this.get(key), defaultValue);
    }

    public List<String> getList(String key) {
        return this.getList(key, "\n");
    }

    public List<String> getList(String key, String separatorChar) {
        ArrayList<String> re = new ArrayList<String>();
        String keyVal = this.get(key);
        if (Strings.isNotBlank(keyVal)) {
            String[] vlist;
            for (String v : vlist = Strings.splitIgnoreBlank(keyVal, separatorChar)) {
                re.add(v);
            }
        }
        return re;
    }

    public String trim(String key) {
        return Strings.trim(this.get(key));
    }

    public String trim(String key, String defaultValue) {
        return Strings.trim(this.get(key, defaultValue));
    }

    public int getInt(String key) {
        return this.getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.get(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String key, long dfval) {
        try {
            return Long.parseLong(this.get(key));
        }
        catch (NumberFormatException e) {
            return dfval;
        }
    }

    public String getTrim(String key) {
        return Strings.trim(this.get(key));
    }

    public String getTrim(String key, String defaultValue) {
        return Strings.trim(this.get(key, defaultValue));
    }

    public List<String> getKeys() {
        return this.keys();
    }

    public Collection<String> getValues() {
        return this.values();
    }

    public Properties toProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this);
        return p;
    }

    public PropertiesProxy joinByKey(String key) {
        String str = this.get(key);
        final PropertiesProxy me = this;
        if (!Strings.isBlank(str)) {
            String[] ss;
            for (String s : ss = Strings.splitIgnoreBlank(str, "\n")) {
                File f = Files.findFile(s);
                if (null == f) {
                    throw Lang.makeThrow("Fail to found path '%s' in CLASSPATH or File System!", s);
                }
                if (f.isDirectory()) {
                    Disks.visitFile(f, new FileVisitor(){

                        @Override
                        public void visit(File f) {
                            me.joinAndClose(Streams.fileInr(f));
                        }
                    }, new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (f.isDirectory()) {
                                return !f.isHidden() && !f.getName().startsWith(".");
                            }
                            return f.getName().endsWith(".properties");
                        }
                    });
                    continue;
                }
                if (!f.isFile()) continue;
                this.joinAndClose(Streams.fileInr(f));
            }
        }
        return this;
    }

    public PropertiesProxy joinAndClose(Reader r) {
        MultiLineProperties mp = new MultiLineProperties();
        try {
            mp.load(r);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(r);
        }
        this.putAll((Map)mp);
        return this;
    }

    public Map<String, String> toMap() {
        return new LinkedHashMap<String, String>(this);
    }

    public String get(String key) {
        return super.get(key);
    }

    public <T> T make(Class<T> klass, String prefix) {
        Mirror<Class<T>> mirror = Mirror.me(klass);
        Class<T> t = mirror.born(new Object[0]);
        Map<String, Object> map = this.toMap();
        map = Lang.filter(map, prefix, null, null, null);
        for (Map.Entry<String, Object> en : map.entrySet()) {
            String name = en.getKey();
            Injecting setter = mirror.getInjecting(name);
            setter.inject(t, en.getValue());
        }
        return (T)t;
    }
}

