/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.DaoException;
import org.nutz.dao.DaoInterceptor;
import org.nutz.dao.impl.DaoExecutor;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlContext;
import org.nutz.lang.random.R;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class DaoInterceptorChain
implements ConnCallback {
    private static final Log log = Logs.get();
    protected int autoTransLevel;
    protected Connection connection;
    protected int current = 0;
    protected DaoStatement daoStatement;
    protected DaoExecutor executor;
    protected List<DaoInterceptor> interceptors = new ArrayList<DaoInterceptor>();
    protected int updateCount;
    protected DaoStatement[] sts;
    protected String id;

    public DaoInterceptorChain(DaoStatement ... sts) {
        this.sts = sts;
        this.id = R.UU32();
    }

    public DaoInterceptorChain doChain() throws DaoException {
        if (this.hasNext()) {
            DaoInterceptor interceptor = this.next();
            ++this.current;
            interceptor.filter(this);
        } else {
            this.executor.exec(this.getConnection(), this.getDaoStatement());
            this.updateCount += this.getDaoStatement().getUpdateCount();
        }
        return this;
    }

    public int getAutoTransLevel() {
        return this.autoTransLevel;
    }

    public DaoStatement getDaoStatement() {
        return this.daoStatement;
    }

    public DaoStatement[] getDaoStatements() {
        return this.sts;
    }

    public List<DaoInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public boolean hasNext() {
        return this.current < this.interceptors.size();
    }

    @Override
    public void invoke(Connection conn) throws Exception {
        for (DaoStatement st : this.sts) {
            if (st == null) {
                if (!log.isInfoEnabled()) continue;
                log.info("Found a null DaoStatement(SQL), ingore it ~~");
                continue;
            }
            this.current = 0;
            this.daoStatement = st;
            this.connection = conn;
            this.doChain();
        }
    }

    public DaoInterceptor next() {
        return this.interceptors.get(this.current);
    }

    public void setAutoTransLevel(int autoTransLevel) {
        this.autoTransLevel = autoTransLevel;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setExecutor(DaoExecutor executor) {
        this.executor = executor;
    }

    public void setInterceptors(List<DaoInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public SqlContext getSqlContext() {
        return this.getDaoStatement().getContext();
    }

    public String getId() {
        return this.id;
    }
}

