/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.nutz.resource.impl.ResourceLocation;

class JarResourceLocation
extends ResourceLocation {
    private static final Log log = Logs.get();
    private List<String> names = new ArrayList<String>();
    String jarPath;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JarResourceLocation other = (JarResourceLocation)obj;
        return !(this.jarPath == null ? other.jarPath != null : !this.jarPath.equals(other.jarPath));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarPath == null ? 0 : this.jarPath.hashCode());
        return result;
    }

    @Override
    public void scan(String base, Pattern regex, List<NutResource> list) {
        for (String ensName : this.names) {
            String name = ensName;
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (!ensName.startsWith(base) || null != regex && !regex.matcher(name).find()) continue;
            try {
                list.add(Scans.makeJarNutResource(this.jarPath, ensName, base));
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) continue;
                log.info("Jar delete while scan?!! " + this.jarPath, e);
            }
        }
    }

    public String toString() {
        return "JarResourceLocation [jarPath=" + this.jarPath + "]";
    }

    public JarResourceLocation(String jarPath) throws IOException {
        if (jarPath.startsWith("zip:")) {
            jarPath = jarPath.substring(4);
        }
        if (jarPath.startsWith("file:/") && !new File(jarPath = jarPath.substring("file:/".length())).exists() && !jarPath.startsWith("/")) {
            jarPath = "/" + jarPath;
        }
        this.jarPath = new File(jarPath).getAbsoluteFile().getCanonicalPath();
        ZipInputStream zis = null;
        try {
            zis = Scans.makeZipInputStream(jarPath);
            ZipEntry ens = null;
            while (null != (ens = zis.getNextEntry())) {
                if (ens.isDirectory()) continue;
                this.names.add(ens.getName());
            }
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(zis);
        }
    }
}

