/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.json.JsonFormat;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.View;

public class UTF8JsonView
implements View {
    public static String CT = "application/json";
    public static String JSONP_CT = "application/javascript";
    protected JsonFormat format;
    protected Object data;
    protected boolean jsonp;
    protected String jsonpParam;
    public static final View NICE = new UTF8JsonView(JsonFormat.nice());
    public static final View COMPACT = new UTF8JsonView(JsonFormat.compact());
    public static final View FULL = new UTF8JsonView(JsonFormat.full());
    public static final View FORLOOK = new UTF8JsonView(JsonFormat.forLook());
    public static final View JSONP = new UTF8JsonView(JsonFormat.compact()).setJsonp(true);

    public UTF8JsonView setData(Object data) {
        this.data = data;
        return this;
    }

    public UTF8JsonView setJsonp(boolean jsonp) {
        this.jsonp = jsonp;
        return this;
    }

    public UTF8JsonView setJsonpParam(String jsonpParam) {
        this.jsonpParam = jsonpParam;
        return this;
    }

    public UTF8JsonView(JsonFormat format) {
        this.format = format;
    }

    public UTF8JsonView() {
        this.format = new JsonFormat();
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws IOException {
        if (resp.getContentType() == null) {
            if (this.jsonp) {
                resp.setContentType(JSONP_CT);
            } else {
                resp.setContentType(CT);
            }
        }
        PrintWriter writer = resp.getWriter();
        if (this.jsonp) {
            ((Writer)writer).write(req.getParameter(this.jsonpParam == null ? "callback" : this.jsonpParam) + "(");
        }
        Mvcs.write(resp, writer, null == obj ? this.data : obj, this.format.clone());
        if (this.jsonp) {
            ((Writer)writer).write(");");
        }
    }
}

