/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.mvc.View;
import org.nutz.mvc.view.HttpServerResponse;

public class HttpStatusView
implements View {
    public static final View HTTP_404 = new HttpStatusView(404);
    public static final View HTTP_500 = new HttpStatusView(500);
    public static final View HTTP_502 = new HttpStatusView(502);
    private HttpServerResponse info;

    public static HttpStatusException makeThrow(int status, String body) {
        return new HttpStatusException(status, body, new Object[0]);
    }

    public HttpStatusView(HttpServerResponse info) {
        this.info = info;
    }

    public HttpStatusView(int statusCode) {
        this.info = new HttpServerResponse();
        this.info.updateCode(statusCode, null);
    }

    public HttpStatusView(Map<?, ?> map) {
        this(200);
        this.info.update(map);
    }

    public HttpStatusView setBody(String body) {
        this.info.updateBody(body);
        return this;
    }

    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) {
        HttpServerResponse info = this.info.clone();
        if (null != obj) {
            if (obj instanceof HttpStatusException) {
                HttpStatusException hse = (HttpStatusException)obj;
                info.updateCode(hse.getStatus(), null);
                info.updateBody(hse.getMessage());
            } else if (obj instanceof Map) {
                info.update((Map)obj);
            } else if (obj instanceof CharSequence) {
                info.updateBy(obj.toString());
            }
        }
        info.render(resp);
    }

    public static class HttpStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 4035188583429445028L;
        private int status;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public HttpStatusException(int status) {
            this.status = status;
        }

        public HttpStatusException(int status, String fmt, Object ... args) {
            super(String.format(fmt, args));
            this.status = status;
        }
    }
}

