/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.nutz.lang.Lang;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.Processor;

public class NutActionChain
implements ActionChain {
    private Processor head;
    private Processor errorProcessor;
    private Method method;
    private Integer lineNumber;
    String methodStr;

    public NutActionChain(List<Processor> list, Processor errorProcessor, ActionInfo ai) {
        Iterator<Processor> it;
        if (null != list && (it = list.iterator()).hasNext()) {
            Processor p = this.head = it.next();
            while (it.hasNext()) {
                Processor next = it.next();
                p.setNext(next);
                p = next;
            }
        }
        this.errorProcessor = errorProcessor;
        this.method = ai.getMethod();
        this.lineNumber = ai.getLineNumber();
    }

    @Override
    public void doChain(ActionContext ac) {
        if (null != this.head) {
            try {
                this.head.process(ac);
            }
            catch (Throwable e) {
                ac.setError(e);
                try {
                    this.errorProcessor.process(ac);
                }
                catch (Throwable ee) {
                    throw Lang.wrapThrow(ee);
                }
            }
        }
    }

    public String toString() {
        if (this.methodStr == null) {
            if (this.lineNumber != null) {
                String className = this.method.getDeclaringClass().getSimpleName();
                String methodName = this.method.getName();
                this.methodStr = String.format("%s.%s(%s.java:%d)", className, methodName, className, this.lineNumber);
            } else {
                this.methodStr = Lang.simpleMetodDesc(this.method);
            }
        }
        return this.methodStr;
    }
}

