/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionContext;

public class ActionInvoker {
    private static final Log log = Logs.get();
    private ActionChain defaultChain;
    private Map<String, ActionChain> chainMap = new HashMap<String, ActionChain>();

    public void addChain(String httpMethod, ActionChain chain) {
        if (Strings.isBlank(httpMethod)) {
            throw Lang.makeThrow("chain need a valid HTTP Method, but is is '%s'", httpMethod);
        }
        ActionChain old = this.chainMap.put(httpMethod.toUpperCase(), chain);
        if (old != null) {
            log.warnf("Duplicate @At mapping with same HttpMethod", new Object[0]);
        }
    }

    public void setDefaultChain(ActionChain defaultChain) {
        this.defaultChain = defaultChain;
    }

    public boolean invoke(ActionContext ac) {
        ActionChain chain = this.getActionChain(ac);
        if (chain == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Not chain for req (path=%s, method=%s)", ac.getPath(), ac.getRequest().getMethod());
            }
            return false;
        }
        chain.doChain(ac);
        return ac.getBoolean("nutz.mvc.done", true);
    }

    public ActionChain getActionChain(ActionContext ac) {
        HttpServletRequest req = ac.getRequest();
        String httpMethod = Strings.sNull(req.getMethod(), "GET").toUpperCase();
        ActionChain chain = this.chainMap.get(httpMethod);
        if (null != chain) {
            return chain;
        }
        if (null != this.defaultChain) {
            return this.defaultChain;
        }
        if (this.chainMap.size() != 0 && log.isDebugEnabled()) {
            log.debugf("Path=[%s] available methods%s but request [%s], using the wrong http method?", ac.getPath(), this.chainMap.keySet(), httpMethod);
        }
        return null;
    }
}

