/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.adaptor;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.Times;
import org.nutz.lang.meta.Pair;
import org.nutz.lang.util.NutMap;
import org.nutz.mvc.adaptor.injector.NameInjector;

public class QueryStringNameInjector
extends NameInjector {
    public QueryStringNameInjector(String name, String datefmt, Type type, Type[] paramTypes, String defaultValue) {
        super(name, datefmt, type, paramTypes, defaultValue);
    }

    @Override
    public Object fromReqParam(HttpServletRequest req) {
        String params;
        if ("?".equals(this.name)) {
            params = req.getQueryString();
        } else {
            NutMap qsMap = (NutMap)req.getAttribute("_nutz_qs_map");
            if (null == qsMap) {
                String[] ss;
                qsMap = new NutMap();
                String qs = req.getQueryString();
                for (String s : ss = Strings.splitIgnoreBlank(qs, "[&]")) {
                    Pair<String> p = Pair.create(s);
                    String val = p.getValue();
                    if (Strings.isBlank(val)) {
                        qsMap.put(p.getName(), true);
                        continue;
                    }
                    try {
                        val = URLDecoder.decode(val, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw Lang.wrapThrow(e);
                    }
                    qsMap.put(p.getName(), val);
                }
                req.setAttribute("_nutz_qs_map", (Object)qsMap);
            }
            params = qsMap.getString(this.name);
        }
        if (null != this.dfmt && params != null) {
            Date o = Times.parseq(this.dfmt, params);
            return Castors.me().castTo(o, this.klass);
        }
        return Castors.me().castTo(params, this.klass);
    }
}

