/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mapl.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MaplMerge {
    public static Object merge(Object ... objs) {
        return new MaplMerge().mergeItems(objs);
    }

    public Object mergeItems(Object ... objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        if (objs.length == 1) {
            return objs[0];
        }
        if (objs[0] instanceof Map) {
            return MaplMerge.mergeMap(objs);
        }
        if (objs[0] instanceof List) {
            return MaplMerge.mergeList(objs);
        }
        return MaplMerge.mergeObj(objs);
    }

    private static Object mergeObj(Object[] objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : objs) {
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    private static Object mergeList(Object ... objs) {
        ArrayList list = new ArrayList();
        for (Object li : objs) {
            List src = (List)li;
            for (Object obj : src) {
                if (list.contains(obj)) continue;
                list.add(obj);
            }
        }
        return list;
    }

    private static Object mergeMap(Object ... objs) {
        LinkedHashMap obj = new LinkedHashMap();
        for (int i = 0; i < objs.length; ++i) {
            Map map = (Map)objs[i];
            for (Object key : map.keySet()) {
                Object objval = obj.get(key);
                Object val = map.get(key);
                if (objval != null && (val instanceof List || val instanceof Map)) {
                    val = MaplMerge.merge(objval, val);
                }
                obj.put(key, val);
            }
        }
        return obj;
    }
}

