/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import org.nutz.castor.Castors;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.DateRegion;
import org.nutz.lang.util.DoubleRegion;
import org.nutz.lang.util.FloatRegion;
import org.nutz.lang.util.IntRegion;
import org.nutz.lang.util.LongRegion;

public abstract class Region<T extends Comparable<T>> {
    protected Class<T> eleType = Mirror.getTypeParam(this.getClass(), 0);
    protected T left;
    protected T right;
    protected boolean leftOpen;
    protected boolean rightOpen;

    public static IntRegion Int(String str) {
        return new IntRegion(str);
    }

    public static IntRegion Intf(String fmt, Object ... args) {
        return new IntRegion(String.format(fmt, args));
    }

    public static LongRegion Long(String str) {
        return new LongRegion(str);
    }

    public static LongRegion Longf(String fmt, Object ... args) {
        return new LongRegion(String.format(fmt, args));
    }

    public static FloatRegion Float(String str) {
        return new FloatRegion(str);
    }

    public static FloatRegion Floatf(String fmt, Object ... args) {
        return new FloatRegion(String.format(fmt, args));
    }

    public static DoubleRegion Double(String str) {
        return new DoubleRegion(str);
    }

    public static DoubleRegion Doublef(String fmt, Object ... args) {
        return new DoubleRegion(String.format(fmt, args));
    }

    public static DateRegion Date(String str) {
        return new DateRegion(str);
    }

    public static DateRegion Datef(String fmt, Object ... args) {
        return new DateRegion(String.format(fmt, args));
    }

    public T left() {
        return this.left;
    }

    public Region<T> left(T left) {
        this.left = left;
        return this;
    }

    public Region<T> leftOpen(boolean open) {
        this.leftOpen = open;
        return this;
    }

    public T right() {
        return this.right;
    }

    public Region<T> right(T right) {
        this.right = right;
        return this;
    }

    public Region<T> rightOpen(boolean open) {
        this.rightOpen = open;
        return this;
    }

    public boolean isLeftOpen() {
        return this.leftOpen;
    }

    public boolean isRightOpen() {
        return this.rightOpen;
    }

    public boolean isRegion() {
        return this.left != this.right && !this.isNull();
    }

    public boolean isNull() {
        return null == this.left && null == this.right;
    }

    public String leftOpt(String gt, String gte) {
        if (null == this.left) {
            return null;
        }
        return this.leftOpen ? gt : gte;
    }

    public String rightOpt(String lt, String lte) {
        if (null == this.right) {
            return null;
        }
        return this.rightOpen ? lt : lte;
    }

    public boolean match(T obj) {
        int c;
        if (null == obj) {
            return false;
        }
        if (!this.isRegion()) {
            return this.left.compareTo(obj) == 0;
        }
        if (null != this.left && ((c = obj.compareTo(this.left)) < 0 || c == 0 && this.leftOpen)) {
            return false;
        }
        return null == this.right || (c = obj.compareTo(this.right)) <= 0 && (c != 0 || !this.rightOpen);
    }

    public Region<T> valueOf(String str) {
        String s2 = Strings.trim(str.substring(1, str.length() - 1));
        this.leftOpen = str.charAt(0) == '(';
        boolean bl = this.rightOpen = str.charAt(str.length() - 1) == ')';
        if (s2.endsWith(",")) {
            this.left = this.fromString(Strings.trim(s2.substring(0, s2.length() - 1)));
            this.right = null;
        } else if (s2.startsWith(",")) {
            this.left = null;
            this.right = this.fromString(Strings.trim(s2.substring(1)));
        } else {
            String[] ss = Strings.splitIgnoreBlank(s2, ",");
            if (1 == ss.length) {
                this.left = this.fromString(ss[0]);
                this.right = this.left;
            } else {
                this.left = this.fromString(ss[0]);
                this.right = this.fromString(ss[1]);
                if (null != this.left && null != this.right && this.left.compareTo(this.right) > 0) {
                    T o = this.right;
                    this.right = this.left;
                    this.left = o;
                }
            }
        }
        return this;
    }

    public String toString(T obj) {
        return null == obj ? "" : obj.toString();
    }

    public T fromString(String str) {
        if (Strings.isEmpty(str = Strings.trim(str))) {
            return null;
        }
        return (T)((Comparable)Castors.me().castTo(str, this.eleType));
    }

    public String toString() {
        if (this.isRegion()) {
            return String.format("%c%s,%s%c", Character.valueOf(this.leftOpen ? (char)'(' : '['), this.toString(this.left), this.toString(this.right), Character.valueOf(this.rightOpen ? (char)')' : ']'));
        }
        return String.format("%c%s%c", Character.valueOf(this.leftOpen ? (char)'(' : '['), this.toString(this.left), Character.valueOf(this.rightOpen ? (char)')' : ']'));
    }
}

