/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.MatchType;
import org.nutz.lang.Mirror;
import org.nutz.lang.reflect.FastClass;

public abstract class AbstractFastClass
implements FastClass {
    private static final String[] cMethodName = new String[]{"create", "newInstance"};
    public static final Class<?>[] EMTRY_PARAM_TYPES = new Class[0];
    protected Class<?> clazz;
    protected Constructor<?>[] cs;
    protected Method[] methods;
    protected Field[] fields;
    protected Class<?>[][] csTypes;
    protected Class<?>[][] methodTypes;
    protected String[] methodNames;

    public AbstractFastClass(Class<?> clazz, Constructor<?>[] cs, Method[] methods, Field[] fields) {
        int i;
        this.clazz = clazz;
        this.cs = cs;
        this.methods = methods;
        this.fields = fields;
        this.csTypes = new Class[cs.length][];
        for (i = 0; i < cs.length; ++i) {
            this.csTypes[i] = cs[i].getParameterTypes();
        }
        this.methodTypes = new Class[methods.length][];
        this.methodNames = new String[methods.length];
        for (i = 0; i < methods.length; ++i) {
            this.methodTypes[i] = methods[i].getParameterTypes();
            this.methodNames[i] = methods[i].getName();
        }
    }

    protected Object _born(int index, Object ... args) {
        throw Lang.noImplement();
    }

    protected Object _invoke(Object obj, int index, Object ... args) {
        throw Lang.noImplement();
    }

    @Override
    public Object setField(Object obj, String fieldName, Object value) {
        throw Lang.noImplement();
    }

    @Override
    public Object getField(Object obj, String fieldName) {
        throw Lang.noImplement();
    }

    @Override
    public Object born(Constructor<?> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("!!Constructor must not NULL !");
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            throw new IllegalArgumentException("!!Constructor is private !");
        }
        return this._born(this.getConstructorIndex(constructor.getParameterTypes()), args);
    }

    @Override
    public Object born(Class<?>[] types, Object ... args) {
        int index = this.getConstructorIndex(types);
        if (index > -1) {
            return this._born(index, args);
        }
        for (int i = 0; i < cMethodName.length; ++i) {
            try {
                Method method = this.getSrcClass().getDeclaredMethod(cMethodName[i], types);
                if (Modifier.isPrivate(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || !this.getSrcClass().isAssignableFrom(method.getReturnType())) continue;
                return this.invoke(null, method, args);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("!!Fail to find Constructor for args");
    }

    @Override
    public Object born() {
        return this.born(EMTRY_PARAM_TYPES, new Object[0]);
    }

    private int getConstructorIndex(Class<?>[] cpB) {
        for (int i = 0; i < this.csTypes.length; ++i) {
            Class<?>[] cpA = this.csTypes[i];
            if (MatchType.YES != Mirror.matchParamTypes(cpA, cpB)) continue;
            return i;
        }
        throw new RuntimeException("!!No such Constructor found!");
    }

    protected Constructor<?>[] getConstructors() {
        return this.cs;
    }

    private int getMethodIndex(Method method) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (this.methods[i].equals(method)) {
                return i;
            }
            if (!this.methods[i].getName().equals(method.getName()) || MatchType.YES != Mirror.matchParamTypes(this.methodTypes[i], method.getParameterTypes())) continue;
            return i;
        }
        throw new RuntimeException("!!No such Method found!");
    }

    private int getMethodIndex(String name, Class<?>[] cpB) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equals(name) || MatchType.YES != Mirror.matchParamTypes(this.methodTypes[i], cpB)) continue;
            return i;
        }
        throw new RuntimeException("!!No such Method found!");
    }

    protected Class<?> getSrcClass() {
        return this.clazz;
    }

    @Override
    public Object invoke(Object obj, Method method, Object ... args) {
        if (method == null) {
            throw new IllegalArgumentException("!!Method must not NULL !");
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new IllegalArgumentException("!!Method is private !");
        }
        if (obj == null && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("!!obj is NULL but Method isn't static !");
        }
        int index = this.getMethodIndex(method);
        if (index > -1) {
            return this._invoke(obj, index, args);
        }
        throw new IllegalArgumentException("!!No such method --> " + method);
    }

    @Override
    public Object invoke(Object obj, String methodName, Class<?>[] types, Object ... args) {
        int index = this.getMethodIndex(methodName, types);
        if (index > -1) {
            return this._invoke(obj, index, args);
        }
        throw new IllegalArgumentException("!!Fail to get method ! For " + Json.toJson(types));
    }
}

