/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.inject;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.nutz.castor.Castors;
import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.inject.Injecting;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class InjectBySetter
implements Injecting {
    private static final Log log = Logs.get();
    private Method setter;
    private Class<?> valueType;
    private Type type;
    private boolean isMapCollection;

    public InjectBySetter(Method setter) {
        this.setter = setter;
        this.valueType = setter.getParameterTypes()[0];
        this.type = setter.getGenericParameterTypes()[0];
        this.isMapCollection = Map.class.isAssignableFrom(this.valueType) || Collection.class.isAssignableFrom(this.valueType);
    }

    @Override
    public void inject(Object obj, Object value) {
        Object v = null;
        try {
            v = this.isMapCollection && value != null && value instanceof String ? Json.fromJson(this.type, (CharSequence)value.toString()) : (Object)Castors.me().castTo(value, this.valueType);
            this.setter.invoke(obj, v);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info("Fail to value by setter", e);
            }
            throw Lang.makeThrow("Fail to set '%s'[ %s ] by setter %s.'%s()' because [%s]: %s", value, v, this.setter.getDeclaringClass().getName(), this.setter.getName(), Lang.unwrapThrow(e), Lang.unwrapThrow(e).getMessage());
        }
    }
}

