/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.hardware;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Strings;
import org.nutz.lang.hardware.NetworkItem;
import org.nutz.lang.hardware.NetworkType;

public class Networks {
    private static Map<NetworkType, String> ntMap = new HashMap<NetworkType, String>();

    public static Map<String, NetworkItem> networkItems() {
        HashMap<String, NetworkItem> netFaces = new HashMap<String, NetworkItem>();
        try {
            Enumeration<NetworkInterface> network = NetworkInterface.getNetworkInterfaces();
            while (network.hasMoreElements()) {
                NetworkItem netItem = new NetworkItem();
                NetworkInterface face = network.nextElement();
                byte[] data = face.getHardwareAddress();
                try {
                    if (data != null && data.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (byte b : data) {
                            sb.append(Strings.toHex(b, 2));
                        }
                        netItem.setMac(sb.toString().toUpperCase());
                    }
                }
                catch (Throwable sb) {
                    // empty catch block
                }
                List<InterfaceAddress> addrs = face.getInterfaceAddresses();
                if (addrs != null && !addrs.isEmpty()) {
                    Object object = addrs.iterator();
                    while (object.hasNext()) {
                        InterfaceAddress interfaceAddress = (InterfaceAddress)object.next();
                        String ip = interfaceAddress.getAddress().getHostAddress();
                        if (ip == null || ip.length() == 0) continue;
                        if (ip.contains(".")) {
                            netItem.setIpv4(ip);
                            continue;
                        }
                        netItem.setIpv6(ip);
                    }
                }
                netItem.setMtu(face.getMTU());
                if (netItem.getIpv4() == null && netItem.getMac() == null && netItem.getMtu() < 1) continue;
                netFaces.put(face.getName(), netItem);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return netFaces;
    }

    public static String ipv4() {
        for (NetworkItem item : Networks.networkItems().values()) {
            if (Strings.isBlank(item.getIpv4()) || "127.0.0.1".equals(item.getIpv4())) continue;
            return item.getIpv4();
        }
        return null;
    }

    public static String ipv4(NetworkType nt) {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        NetworkItem networkItem = Networks.getNetworkByType(netFaces, ntMap.get((Object)nt));
        return networkItem == null ? null : networkItem.getIpv4();
    }

    public static String mac() {
        NetworkItem networkItem = Networks.firstNetwokrItem();
        if (networkItem == null) {
            return null;
        }
        return networkItem.getMac();
    }

    public static String mac(NetworkType nt) {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        NetworkItem networkItem = Networks.getNetworkByType(netFaces, ntMap.get((Object)nt));
        return networkItem == null ? null : networkItem.getMac();
    }

    private static NetworkItem firstNetwokrItem() {
        Map<String, NetworkItem> netFaces = Networks.networkItems();
        if (netFaces.isEmpty()) {
            return null;
        }
        NetworkItem re = null;
        re = Networks.getNetworkByType(netFaces, ntMap.get((Object)NetworkType.LAN));
        if (re == null) {
            re = Networks.getNetworkByType(netFaces, ntMap.get((Object)NetworkType.WIFI));
        }
        if (re == null) {
            re = Networks.getNetworkByType(netFaces, ntMap.get((Object)NetworkType.ThreeG));
        }
        if (re == null) {
            re = Networks.getNetworkByType(netFaces, ntMap.get((Object)NetworkType.VPN));
        }
        if (re == null) {
            for (Map.Entry<String, NetworkItem> en : netFaces.entrySet()) {
                if (Strings.isBlank(en.getValue().getIpv4()) || Strings.isBlank(en.getValue().getMac())) continue;
                return en.getValue();
            }
        }
        return re;
    }

    private static NetworkItem getNetworkByType(Map<String, NetworkItem> netFaces, String nt) {
        String[] nss;
        for (String ns : nss = Strings.splitIgnoreBlank(nt, ",")) {
            for (int i = 0; i < 10; ++i) {
                if (!netFaces.containsKey(ns + i)) continue;
                return netFaces.get(ns + i);
            }
        }
        return null;
    }

    static {
        ntMap.put(NetworkType.LAN, "eth, en");
        ntMap.put(NetworkType.WIFI, "wlan");
        ntMap.put(NetworkType.ThreeG, "ppp");
        ntMap.put(NetworkType.VPN, "tun");
    }
}

