/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.Encoding;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.stream.NullInputStream;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;

public abstract class Streams {
    private static final int BUF_SIZE = 8192;
    private static final byte[] UTF_BOM = new byte[]{-17, -69, -65};

    public static boolean equals(InputStream sA, InputStream sB) throws IOException {
        int dA;
        while ((dA = sA.read()) != -1) {
            int dB = sB.read();
            if (dA == dB) continue;
            return false;
        }
        return sB.read() == -1;
    }

    public static void write(Writer writer, CharSequence cs) throws IOException {
        if (null != cs && null != writer) {
            writer.write(cs.toString());
            writer.flush();
        }
    }

    public static void writeAndClose(Writer writer, CharSequence cs) {
        try {
            Streams.write(writer, cs);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(writer);
        }
    }

    public static long write(OutputStream ops, InputStream ins) throws IOException {
        return Streams.write(ops, ins, 8192);
    }

    public static long write(OutputStream ops, InputStream ins, int bufferSize) throws IOException {
        int len;
        if (null == ops || null == ins) {
            return 0L;
        }
        byte[] buf = new byte[bufferSize];
        long bytesCount = 0L;
        while (-1 != (len = ins.read(buf))) {
            bytesCount += (long)len;
            ops.write(buf, 0, len);
        }
        if (0L == bytesCount) {
            ops.write(buf, 0, 0);
        }
        ops.flush();
        return bytesCount;
    }

    public static long writeAndClose(OutputStream ops, InputStream ins) {
        try {
            long l = Streams.write(ops, ins);
            return l;
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ops);
            Streams.safeClose(ins);
        }
    }

    public static void write(Writer writer, Reader reader) throws IOException {
        int len;
        if (null == writer || null == reader) {
            return;
        }
        char[] cbuf = new char[8192];
        while (-1 != (len = reader.read(cbuf))) {
            writer.write(cbuf, 0, len);
        }
    }

    public static void writeAndClose(Writer writer, Reader reader) {
        try {
            Streams.write(writer, reader);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(writer);
            Streams.safeClose(reader);
        }
    }

    public static void write(OutputStream ops, byte[] bytes) throws IOException {
        if (null == ops || null == bytes || bytes.length == 0) {
            return;
        }
        ops.write(bytes);
    }

    public static void writeAndClose(OutputStream ops, byte[] bytes) {
        try {
            Streams.write(ops, bytes);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ops);
        }
    }

    public static StringBuilder read(Reader reader) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder();
        char[] cbuf = new char[8192];
        while (-1 != (len = reader.read(cbuf))) {
            sb.append(cbuf, 0, len);
        }
        return sb;
    }

    public static String readAndClose(Reader reader) {
        try {
            String string = Streams.read(reader).toString();
            return string;
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(reader);
        }
    }

    public static byte[] readBytes(InputStream ins) throws IOException {
        byte[] bytes = new byte[ins.available()];
        ins.read(bytes);
        return bytes;
    }

    public static byte[] readBytesAndClose(InputStream ins) {
        byte[] bytes = null;
        try {
            bytes = Streams.readBytes(ins);
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(ins);
        }
        return bytes;
    }

    public static boolean safeClose(Closeable cb) {
        if (null != cb) {
            try {
                cb.close();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void safeFlush(Flushable fa) {
        if (null != fa) {
            try {
                fa.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static BufferedInputStream buff(InputStream ins) {
        if (ins == null) {
            throw new NullPointerException("ins is null!");
        }
        if (ins instanceof BufferedInputStream) {
            return (BufferedInputStream)ins;
        }
        return new BufferedInputStream(ins);
    }

    public static BufferedOutputStream buff(OutputStream ops) {
        if (ops == null) {
            throw new NullPointerException("ops is null!");
        }
        if (ops instanceof BufferedOutputStream) {
            return (BufferedOutputStream)ops;
        }
        return new BufferedOutputStream(ops);
    }

    public static BufferedReader buffr(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    public static BufferedWriter buffw(Writer ops) {
        if (ops instanceof BufferedWriter) {
            return (BufferedWriter)ops;
        }
        return new BufferedWriter(ops);
    }

    public static InputStream fileIn(String path) {
        File f;
        InputStream ins = Files.findFileAsStream(path);
        if (null == ins && null != (f = Files.findFile(path))) {
            try {
                ins = Streams._input(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null == ins) {
            throw new RuntimeException(new FileNotFoundException(path));
        }
        return Streams.buff(ins);
    }

    public static InputStream fileIn(File file) {
        try {
            return Streams.buff(Streams._input(file));
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Reader fileInr(String path) {
        return Streams.utf8r(Streams.fileIn(path));
    }

    public static Reader fileInr(File file) {
        return Streams.utf8r(Streams.fileIn(file));
    }

    public static InputStream utf8filte(InputStream in) {
        try {
            if (in.available() == -1) {
                return in;
            }
            PushbackInputStream pis = new PushbackInputStream(in, 3);
            byte[] header = new byte[3];
            int len = pis.read(header, 0, 3);
            if (len < 1) {
                return in;
            }
            if (header[0] != UTF_BOM[0] || header[1] != UTF_BOM[1] || header[2] != UTF_BOM[2]) {
                pis.unread(header, 0, len);
            }
            return pis;
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static OutputStream fileOut(String path) {
        return Streams.fileOut(Files.findFile(path));
    }

    public static OutputStream fileOut(File file) {
        try {
            return Streams.buff(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw Lang.wrapThrow(e);
        }
    }

    public static Writer fileOutw(String path) {
        return Streams.fileOutw(Files.findFile(path));
    }

    public static Writer fileOutw(File file) {
        return Streams.utf8w(Streams.fileOut(file));
    }

    public static Reader utf8r(InputStream is) {
        return new InputStreamReader(Streams.utf8filte(is), Encoding.CHARSET_UTF8);
    }

    public static Writer utf8w(OutputStream os) {
        return new OutputStreamWriter(os, Encoding.CHARSET_UTF8);
    }

    public static InputStream nullInputStream() {
        return new NullInputStream();
    }

    public static InputStream wrap(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static int eachLine(Reader r, Each<String> callback) {
        if (null == callback || null == r) {
            return 0;
        }
        BufferedReader br = null;
        try {
            String line;
            br = Streams.buffr(r);
            int index = 0;
            while (null != (line = br.readLine())) {
                try {
                    callback.invoke(index++, line, -1);
                }
                catch (ExitLoop e) {
                    break;
                }
                catch (ContinueLoop e) {
                }
            }
            int n = index;
            return n;
        }
        catch (IOException e2) {
            throw Lang.wrapThrow(e2);
        }
        finally {
            Streams.safeClose(br);
        }
    }

    protected static InputStream _input(File file) throws IOException {
        NutResource nutResource;
        if (file.exists()) {
            return new FileInputStream(file);
        }
        if (Scans.isInJar(file) && (nutResource = Scans.makeJarNutResource(file)) != null) {
            return nutResource.getInputStream();
        }
        throw new FileNotFoundException(file.toString());
    }

    public static void appendWriteAndClose(File f, String text) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(f, true);
            fw.write(text);
        }
        catch (IOException e) {
            try {
                throw Lang.wrapThrow(e);
            }
            catch (Throwable throwable) {
                Streams.safeClose(fw);
                throw throwable;
            }
        }
        Streams.safeClose(fw);
    }

    public static String nextLineTrim(BufferedReader br) throws IOException {
        String line = null;
        while (br.ready() && (line = br.readLine()) != null) {
            if (Strings.isBlank(line)) continue;
            return line.trim();
        }
        return line;
    }
}

