/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.util.regex.Pattern;
import org.nutz.lang.Strings;

public abstract class Nums {
    public static Radix evalRadix(String str) {
        if (str.startsWith("0x")) {
            return new Radix(str.substring(2), 16);
        }
        if (str.startsWith("0") && str.length() > 1) {
            return new Radix(str.substring(1), 8);
        }
        if (str.startsWith("0b")) {
            return new Radix(str.substring(2), 2);
        }
        return new Radix(str, 10);
    }

    public static int[] splitInt(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        int[] ns = new int[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Integer.parseInt(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1;
            }
        }
        return ns;
    }

    public static long[] splitLong(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        long[] ns = new long[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Long.parseLong(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1L;
            }
        }
        return ns;
    }

    public static float[] splitFloat(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        float[] ns = new float[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Float.parseFloat(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = 0.0f;
            }
        }
        return ns;
    }

    public static double[] splitDouble(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        double[] ns = new double[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Long.parseLong(ss[i]);
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = -1.0;
            }
        }
        return ns;
    }

    public static boolean[] splitBoolean(String str) {
        String[] ss = Strings.splitIgnoreBlank(str);
        if (null == ss) {
            return null;
        }
        boolean[] ns = new boolean[ss.length];
        for (int i = 0; i < ns.length; ++i) {
            try {
                ns[i] = Pattern.matches("^(1|yes|true|on)$", ss[i].toLowerCase());
                continue;
            }
            catch (NumberFormatException e) {
                ns[i] = false;
            }
        }
        return ns;
    }

    public static int indexOf(int[] arr, int v) {
        return Nums.indexOf(arr, v, 0);
    }

    public static int indexOf(int[] arr, int v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] arr, int v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] arr, char v) {
        if (null != arr) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(char[] arr, char v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] arr, char v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(long[] arr, long v) {
        return Nums.indexOf(arr, v, 0);
    }

    public static int indexOf(long[] arr, long v, int off) {
        if (null != arr) {
            for (int i = off; i < arr.length; ++i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] arr, long v) {
        if (null != arr) {
            for (int i = arr.length - 1; i >= 0; --i) {
                if (arr[i] != v) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] array(int ... is) {
        return is;
    }

    public static boolean isin(int[] arr, int i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static int[] join(int[] arr, int ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        int[] re = new int[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (int num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static long[] arrayL(long ... is) {
        return is;
    }

    public static boolean isin(long[] arr, long i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static long[] join(long[] arr, long ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        long[] re = new long[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (long num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static char[] arrayC(char ... is) {
        return is;
    }

    public static boolean isin(char[] arr, char i) {
        return Nums.indexOf(arr, i) >= 0;
    }

    public static char[] join(char[] arr, char ... is) {
        if (null == arr) {
            return is;
        }
        int length = arr.length + is.length;
        char[] re = new char[length];
        System.arraycopy(arr, 0, re, 0, arr.length);
        int i = arr.length;
        for (char num : is) {
            re[i++] = num;
        }
        return re;
    }

    public static class Radix {
        public int radix;
        public String val;

        Radix(String val, int radix) {
            this.val = val;
            this.radix = radix;
        }
    }
}

