/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.nutz.json.JsonField;
import org.nutz.json.JsonIgnore;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.eject.EjectByGetter;
import org.nutz.lang.eject.Ejecting;
import org.nutz.lang.inject.InjectBySetter;
import org.nutz.lang.inject.Injecting;

public class JsonEntityField {
    private String name;
    private boolean ignore;
    private Type genericType;
    private Injecting injecting;
    private Ejecting ejecting;
    private boolean forceString;
    private double ignoreNullDouble = -0.94518;
    private int ignoreNullInt = -94518;
    private boolean isInt;
    private boolean isDouble;
    private boolean hasJsonIgnore;
    private Format dataFormat;

    public boolean isForceString() {
        return this.forceString;
    }

    public void setForceString(boolean forceString) {
        this.forceString = forceString;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public static JsonEntityField eval(String name, Method getter, Method setter) {
        JsonEntityField jef = new JsonEntityField();
        jef.genericType = getter.getGenericReturnType();
        jef.name = name;
        jef.ejecting = new EjectByGetter(getter);
        jef.injecting = new InjectBySetter(setter);
        return jef;
    }

    public static JsonEntityField eval(Mirror<?> mirror, Field fld) {
        JsonIgnore jsonIgnore;
        if (fld == null) {
            return null;
        }
        if (fld.getName().startsWith("$") && fld.getAnnotation(JsonField.class) == null) {
            return null;
        }
        JsonField jf = fld.getAnnotation(JsonField.class);
        JsonEntityField jef = new JsonEntityField();
        jef.genericType = Lang.getFieldType(mirror, fld);
        jef.name = Strings.sBlank(null == jf ? null : jf.value(), fld.getName());
        jef.ejecting = mirror.getEjecting(fld.getName());
        jef.injecting = mirror.getInjecting(fld.getName());
        if (Modifier.isTransient(fld.getModifiers()) || null != jf && jf.ignore()) {
            jef.setIgnore(true);
        }
        if (null != jf) {
            jef.setForceString(jf.forceString());
            String dataFormat = jf.dataFormat();
            if (Strings.isBlank(dataFormat)) {
                dataFormat = jf.dateFormat();
            }
            if (!Strings.isBlank(dataFormat)) {
                Mirror jfmirror = Mirror.me(jef.genericType);
                if (jfmirror.isNumber()) {
                    jef.dataFormat = new DecimalFormat(dataFormat);
                } else if (jfmirror.isDateTimeLike()) {
                    jef.dataFormat = new SimpleDateFormat(dataFormat);
                }
            }
        }
        if ((jsonIgnore = fld.getAnnotation(JsonIgnore.class)) != null) {
            Mirror<Class<?>> fldMirror = Mirror.me(fld.getType());
            jef.isInt = fldMirror.isInt();
            jef.isDouble = fldMirror.isDouble() || fldMirror.isFloat();
            jef.hasJsonIgnore = true;
            if (jef.isDouble) {
                jef.ignoreNullDouble = jsonIgnore.null_double();
            }
            if (jef.isInt) {
                jef.ignoreNullInt = jsonIgnore.null_int();
            }
        }
        return jef;
    }

    private JsonEntityField() {
    }

    public String getName() {
        return this.name;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setValue(Object obj, Object value) {
        if (this.injecting != null) {
            this.injecting.inject(obj, value);
        }
    }

    public Object getValue(Object obj) {
        if (this.ejecting == null) {
            return null;
        }
        Object val = this.ejecting.eject(obj);
        if (val == null) {
            return null;
        }
        if (this.hasJsonIgnore) {
            if (this.isInt && ((Number)val).intValue() == this.ignoreNullInt) {
                return null;
            }
            if (this.isDouble && ((Number)val).doubleValue() == this.ignoreNullDouble) {
                return null;
            }
        }
        return val;
    }

    public Format getDataFormat() {
        return this.dataFormat == null ? null : (Format)this.dataFormat.clone();
    }

    public boolean hasDataFormat() {
        return this.dataFormat != null;
    }
}

