/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.nutz.castor.Castors;
import org.nutz.json.JsonField;

public class JsonFormat
implements Cloneable {
    private int indent;
    private String indentBy;
    private boolean compact;
    private boolean quoteName;
    private boolean ignoreNull;
    private Pattern actived;
    private Pattern locked;
    @JsonField(ignore=true)
    private Castors castors;
    private char separator;
    private boolean autoUnicode;
    private boolean unicodeLower;
    private SimpleDateFormat dateFormat;
    private NumberFormat numberFormat;

    public static JsonFormat compact() {
        return new JsonFormat(true).setIgnoreNull(true);
    }

    public static JsonFormat full() {
        return new JsonFormat(false).setIgnoreNull(false);
    }

    public static JsonFormat nice() {
        return new JsonFormat(false).setIgnoreNull(true);
    }

    public static JsonFormat forLook() {
        return new JsonFormat(false).setQuoteName(false).setIgnoreNull(true);
    }

    public static JsonFormat tidy() {
        return new JsonFormat(true).setIgnoreNull(false);
    }

    public JsonFormat() {
        this(true);
    }

    public JsonFormat(boolean compact) {
        this.compact = compact;
        this.indentBy = "   ";
        this.quoteName = true;
        this.castors = Castors.me();
        this.separator = (char)34;
    }

    public boolean ignore(String name) {
        if (null != this.actived) {
            return !this.actived.matcher(name).find();
        }
        if (null != this.locked) {
            return this.locked.matcher(name).find();
        }
        return false;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public JsonFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public int getIndent() {
        return this.indent;
    }

    public JsonFormat setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public JsonFormat increaseIndent() {
        ++this.indent;
        return this;
    }

    public JsonFormat decreaseIndent() {
        --this.indent;
        return this;
    }

    public String getIndentBy() {
        return this.indentBy;
    }

    public JsonFormat setIndentBy(String indentBy) {
        this.indentBy = indentBy;
        return this;
    }

    public boolean isQuoteName() {
        return this.quoteName;
    }

    public JsonFormat setQuoteName(boolean quoteName) {
        this.quoteName = quoteName;
        return this;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public JsonFormat setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    public JsonFormat setActived(String regex) {
        this.actived = Pattern.compile(regex);
        return this;
    }

    public JsonFormat setLocked(String regex) {
        this.locked = Pattern.compile(regex);
        return this;
    }

    public Castors getCastors() {
        return this.castors == null ? Castors.me() : this.castors;
    }

    public JsonFormat setCastors(Castors castors) {
        this.castors = castors;
        return this;
    }

    public JsonFormat setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public JsonFormat setAutoUnicode(boolean autoUnicode) {
        this.autoUnicode = autoUnicode;
        return this;
    }

    public boolean isAutoUnicode() {
        return this.autoUnicode;
    }

    public boolean isUnicodeLower() {
        return this.unicodeLower;
    }

    public JsonFormat setUnicodeLower(boolean unicodeLower) {
        this.unicodeLower = unicodeLower;
        return this;
    }

    public JsonFormat setDateFormat(String df) {
        this.dateFormat = df == null ? null : new SimpleDateFormat(df);
        return this;
    }

    public JsonFormat setDateFormat(SimpleDateFormat df) {
        this.dateFormat = df;
        return this;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat == null ? null : (SimpleDateFormat)this.dateFormat.clone();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat == null ? null : (NumberFormat)this.numberFormat.clone();
    }

    public JsonFormat setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        return this;
    }

    public JsonFormat clone() {
        JsonFormat jf = new JsonFormat();
        jf.indent = this.indent;
        jf.indentBy = this.indentBy;
        jf.compact = this.compact;
        jf.quoteName = this.quoteName;
        jf.ignoreNull = this.ignoreNull;
        jf.actived = this.actived;
        jf.locked = this.locked;
        jf.castors = this.castors;
        jf.separator = this.separator;
        jf.autoUnicode = this.autoUnicode;
        jf.unicodeLower = this.unicodeLower;
        jf.dateFormat = this.dateFormat;
        jf.numberFormat = this.numberFormat;
        return jf;
    }
}

