/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop.config.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.matcher.MethodMatcherFactory;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.aop.config.AopConfigration;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.ioc.aop.config.impl.AopConfigrationItem;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;

public abstract class AbstractAopConfigration
implements AopConfigration {
    private List<AopConfigrationItem> aopItemList;
    private HashMap<String, MethodInterceptor> cachedMethodInterceptor = new HashMap();

    @Override
    public List<InterceptorPair> getInterceptorPairList(Ioc ioc, Class<?> clazz) {
        ArrayList<InterceptorPair> ipList = new ArrayList<InterceptorPair>();
        for (AopConfigrationItem aopItem : this.aopItemList) {
            if (!aopItem.matchClassName(clazz.getName())) continue;
            ipList.add(new InterceptorPair(this.getMethodInterceptor(ioc, aopItem.getInterceptor(), aopItem.isSingleton()), MethodMatcherFactory.matcher(aopItem.getMethodName())));
        }
        return ipList;
    }

    public void setAopItemList(List<AopConfigrationItem> aopItemList) {
        this.aopItemList = aopItemList;
    }

    protected MethodInterceptor getMethodInterceptor(Ioc ioc, String interceptorName, boolean singleton) {
        if (interceptorName.startsWith("ioc:")) {
            return ioc.get(MethodInterceptor.class, interceptorName.substring(4));
        }
        try {
            if (!singleton) {
                return (MethodInterceptor)((Object)Mirror.me(Lang.loadClass(interceptorName)).born(new Object[0]));
            }
            MethodInterceptor methodInterceptor = this.cachedMethodInterceptor.get(interceptorName);
            if (methodInterceptor == null) {
                methodInterceptor = (MethodInterceptor)((Object)Mirror.me(Lang.loadClass(interceptorName)).born(new Object[0]));
                this.cachedMethodInterceptor.put(interceptorName, methodInterceptor);
            }
            return methodInterceptor;
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
    }
}

