/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.matcher.SimpleMethodMatcher;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.aop.config.AopConfigration;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocObject;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public abstract class SimpleAopMaker<T extends Annotation>
implements IocLoader,
AopConfigration {
    protected Class<T> annoClass = Mirror.getTypeParam(this.getClass(), 0);

    public String _name() {
        return Strings.lowerFirst(this._anno().getSimpleName());
    }

    public Class<T> _anno() {
        return this.annoClass;
    }

    public abstract List<? extends MethodInterceptor> makeIt(T var1, Method var2, Ioc var3);

    public boolean checkMethod(Method method) {
        int mod = method.getModifiers();
        return mod != 0 && !Modifier.isStatic(mod) && !Modifier.isPrivate(mod) && !Modifier.isFinal(mod) && !Modifier.isAbstract(mod);
    }

    public boolean checkClass(Class<?> klass) {
        return !klass.isInterface() && !klass.isArray() && !klass.isEnum() && !klass.isPrimitive() && !klass.isMemberClass() && !klass.isAnnotation() && !klass.isAnonymousClass();
    }

    @Override
    public List<InterceptorPair> getInterceptorPairList(Ioc ioc, Class<?> klass) {
        if (!this.checkClass(klass)) {
            return null;
        }
        ArrayList<InterceptorPair> list = new ArrayList<InterceptorPair>();
        for (Method method : klass.getDeclaredMethods()) {
            List<MethodInterceptor> _list;
            T t;
            if (!this.checkMethod(method) || (t = method.getAnnotation(this._anno())) == null || (_list = this.makeIt(t, method, ioc)) == null) continue;
            for (MethodInterceptor mi : _list) {
                list.add(new InterceptorPair(mi, new SimpleMethodMatcher(method)));
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public String[] getName() {
        return new String[]{"$aop_" + this._name()};
    }

    @Override
    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        IocObject iobj = Iocs.wrap(this);
        iobj.setType(this.getClass());
        IocEventSet events = new IocEventSet();
        events.setDepose("depose");
        events.setCreate("init");
        events.setFetch("fetch");
        iobj.setEvents(events);
        return iobj;
    }

    @Override
    public boolean has(String name) {
        return ("$aop_" + this._name()).equals(name);
    }

    public void init() throws Exception {
    }

    public void fetch() throws Exception {
    }

    public void depose() throws Exception {
    }
}

